/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.guicomponent.slotpanel;

import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.inventory.BackgroundRenderedSlot;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.util.Rectangle;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.slotpanel.ModularSlotPanel;

public final class ModularSlotPanelClient
extends GuiComponentClient<ModularSlotPanel.Params, ModularSlotPanel.Data> {
    public ModularSlotPanelClient(ModularSlotPanel.Params params, ModularSlotPanel.Data data) {
        super((Object)params, (Object)data);
    }

    public void setupMenu(final GuiComponent.MenuFacade menu) {
        int i = 0;
        while (i < ((ModularSlotPanel.Params)this.params).slots().size()) {
            final int slotIndex = i++;
            final ModularSlotPanel.Slot slot = ((ModularSlotPanel.Params)this.params).slots().get(slotIndex);
            final Supplier<Integer> stackLimit = () -> ((ModularSlotPanel.Data)this.data).stackLimits().get(slotIndex);
            class ClientSlot
            extends SlotWithBackground
            implements SlotTooltip {
                public ClientSlot() {
                    super((Container)new SimpleContainer(1), 0, ModularSlotPanel.getSlotX(menuFacade.getGuiParams()), ModularSlotPanel.getSlotY(n) + ((ModularSlotPanel.Params)this$0.params).offsetY());
                }

                public boolean mayPlace(ItemStack stack) {
                    return slot.insertionChecker().test(stack);
                }

                public int getMaxStackSize() {
                    return (Integer)stackLimit.get();
                }

                public ResourceLocation getBackgroundAtlasLocation() {
                    ResourceLocation atlas = slot.atlas();
                    return atlas == null ? super.getBackgroundAtlasLocation() : atlas;
                }

                public int getBackgroundU() {
                    return this.hasItem() ? 0 : slot.u();
                }

                public int getBackgroundV() {
                    return this.hasItem() ? 0 : slot.v();
                }

                @Override
                public Component getTooltip() {
                    return slot.tooltip().get();
                }
            }
            menu.addSlotToMenu((Slot)new ClientSlot(), slot.group());
        }
    }

    public ClientComponentRenderer createRenderer(final MachineScreen machineScreen) {
        return new ClientComponentRenderer(){

            private Rectangle getBox(int leftPos, int topPos) {
                return new Rectangle(leftPos + machineScreen.getGuiParams().backgroundWidth, topPos + 10 + ((ModularSlotPanel.Params)ModularSlotPanelClient.this.params).offsetY(), 31, 14 + ((ModularSlotPanel.Params)ModularSlotPanelClient.this.params).slots().size() * 20);
            }

            public void addExtraBoxes(List<Rectangle> rectangles, int leftPos, int topPos) {
                rectangles.add(this.getBox(leftPos, topPos));
            }

            public void renderBackground(GuiGraphics graphics, int x, int y) {
                Rectangle box = this.getBox(x, y);
                int textureX = box.x() - x - box.w();
                graphics.blit(MachineScreen.BACKGROUND, box.x(), box.y(), textureX, 0, box.w(), box.h() - 4);
                graphics.blit(MachineScreen.BACKGROUND, box.x(), box.y() + box.h() - 4, textureX, 252, box.w(), 4);
            }

            public void renderTooltip(MachineScreen screen, Font font, GuiGraphics graphics, int x, int y, int cursorX, int cursorY) {
                Slot slot = screen.getFocusedSlot();
                if (slot instanceof SlotTooltip) {
                    SlotTooltip tooltip = (SlotTooltip)slot;
                    if (!screen.getFocusedSlot().hasItem()) {
                        graphics.renderTooltip(font, tooltip.getTooltip(), cursorX, cursorY);
                    }
                }
            }
        };
    }

    public static class SlotWithBackground
    extends Slot
    implements BackgroundRenderedSlot {
        public SlotWithBackground(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }
    }

    static interface SlotTooltip {
        public Component getTooltip();
    }
}

