/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.tree_decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.registries.PastelTreeDecoratorTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class FrondsDecorator
extends TreeDecorator {
    public static final MapCodec<FrondsDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("chance").forGetter(FrondsDecorator::getChance), (App)BlockStateProvider.CODEC.fieldOf("middle_block").forGetter(FrondsDecorator::getMiddleBlock), (App)BlockStateProvider.CODEC.fieldOf("last_block").forGetter(FrondsDecorator::getBottomBlock), (App)IntProvider.POSITIVE_CODEC.fieldOf("length").forGetter(FrondsDecorator::getLengthProvider)).apply((Applicative)instance, FrondsDecorator::new));
    public final float chance;
    public final BlockStateProvider middleBlock;
    public final BlockStateProvider bottomBlock;
    public final IntProvider lengthProvider;

    public FrondsDecorator(float chance, BlockStateProvider middleBlock, BlockStateProvider bottomBlock, IntProvider lengthProvider) {
        this.chance = chance;
        this.middleBlock = middleBlock;
        this.bottomBlock = bottomBlock;
        this.lengthProvider = lengthProvider;
    }

    public BlockStateProvider getMiddleBlock() {
        return this.middleBlock;
    }

    public BlockStateProvider getBottomBlock() {
        return this.bottomBlock;
    }

    public IntProvider getLengthProvider() {
        return this.lengthProvider;
    }

    public float getChance() {
        return this.chance;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)PastelTreeDecoratorTypes.FRONDS.value();
    }

    public void place(TreeDecorator.Context generator) {
        RandomSource random = generator.random();
        for (BlockPos pos : generator.leaves()) {
            if (!generator.isAir(pos.below()) || random.nextFloat() > this.chance) continue;
            int length = this.lengthProvider.sample(random);
            int i = 1;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos.getX(), pos.getY() - i, pos.getZ());
            while (i < length && generator.isAir((BlockPos)mutable) && generator.isAir(mutable.below())) {
                generator.setBlock((BlockPos)mutable, this.middleBlock.getState(random, (BlockPos)mutable));
                mutable.set(pos.getX(), pos.getY() - ++i, pos.getZ());
            }
            if (!generator.isAir((BlockPos)mutable)) continue;
            generator.setBlock((BlockPos)mutable, this.bottomBlock.getState(random, (BlockPos)mutable));
        }
    }
}

