/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.worldgen.features.WallPatchFeatureConfig;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class WallPatchFeature
extends Feature<WallPatchFeatureConfig> {
    public WallPatchFeature(Codec<WallPatchFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<WallPatchFeatureConfig> context) {
        WorldGenLevel structureWorldAccess = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        WallPatchFeatureConfig config = (WallPatchFeatureConfig)context.config();
        if (!WallPatchFeature.isAirOrWater(structureWorldAccess.getBlockState(blockPos))) {
            return false;
        }
        List<Direction> shuffledDirections = config.shuffleDirections(random);
        if (WallPatchFeature.generate(structureWorldAccess, blockPos, config, random)) {
            return true;
        }
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        block0: for (Direction direction : shuffledDirections) {
            mutable.set((Vec3i)blockPos);
            for (int i = 0; i < config.searchRange; ++i) {
                mutable.setWithOffset((Vec3i)blockPos, direction);
                BlockState blockState = structureWorldAccess.getBlockState((BlockPos)mutable);
                if (!WallPatchFeature.isAirOrWater(blockState) && !blockState.is(config.block)) continue block0;
                if (!WallPatchFeature.generate(structureWorldAccess, (BlockPos)mutable, config, random)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean generate(WorldGenLevel world, BlockPos pos, WallPatchFeatureConfig config, RandomSource random) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        boolean success = false;
        for (BlockPos currPos : BlockPos.withinManhattan((BlockPos)pos, (int)config.width.sample(random), (int)config.height.sample(random), (int)config.width.sample(random))) {
            Direction direction;
            if (!WallPatchFeature.isAirOrWater(world.getBlockState(currPos))) continue;
            Iterator<Direction> directionIterator = config.shuffleDirections(random).iterator();
            boolean canBePlaced = false;
            do {
                BlockState posState;
                if (!(posState = world.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)currPos, direction = directionIterator.next()))).is(config.canPlaceOn)) continue;
                canBePlaced = true;
            } while (!canBePlaced && directionIterator.hasNext());
            if (!canBePlaced) continue;
            BlockState stateToPlace = config.block.defaultBlockState();
            if (config.block instanceof DirectionalBlock) {
                stateToPlace = (BlockState)stateToPlace.setValue((Property)BlockStateProperties.FACING, (Comparable)direction.getOpposite());
            }
            if (stateToPlace == null) continue;
            world.setBlock(currPos, stateToPlace, 3);
            success = true;
        }
        return success;
    }

    private static boolean isAirOrWater(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER);
    }
}

