/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.blocks.deeper_down.flora.TriStateVineBlock;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.worldgen.features.TriStateVineFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class TriStateVineFeature
extends Feature<TriStateVineFeatureConfig> {
    public TriStateVineFeature(Codec<TriStateVineFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<TriStateVineFeatureConfig> context) {
        int stemHeight;
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        ChunkGenerator chunkGen = context.chunkGenerator();
        TriStateVineFeatureConfig config = (TriStateVineFeatureConfig)context.config();
        BlockState floorState = world.getBlockState(origin.above());
        if (!floorState.is(BlockTags.DIRT) && !floorState.is(PastelBlockTags.BASE_STONE_DEEPER_DOWN)) {
            return false;
        }
        float berryChance = config.berryChance();
        Block vineBlock = config.vineBlock();
        if (!(vineBlock instanceof TriStateVineBlock)) {
            throw new IllegalStateException("TriStateVineFeatures must use TriStateVineBlocks!");
        }
        if (berryChance > 0.0f && !vineBlock.defaultBlockState().hasProperty((Property)BlockStateProperties.BERRIES)) {
            throw new IllegalStateException("Attempted to generate fruits for a vine with no fruiting state!");
        }
        int minHeight = config.minHeight().sample(random);
        float overgrowth = config.overgrowth().sample(random);
        BlockPos.MutableBlockPos mutablePos = origin.mutable();
        for (stemHeight = 0; stemHeight < minHeight * 3; ++stemHeight) {
            mutablePos.move(Direction.DOWN);
            if (mutablePos.getY() < chunkGen.getMinY() || !TriStateVineFeature.isReplaceable((LevelAccessor)world, (BlockPos)mutablePos) || stemHeight > minHeight && random.nextFloat() > overgrowth) break;
        }
        if (stemHeight <= config.cutoff()) {
            return false;
        }
        this.generateStem((LevelAccessor)world, random, origin, vineBlock, stemHeight, berryChance);
        return true;
    }

    private static boolean isReplaceable(LevelAccessor world, BlockPos pos) {
        return world.getBlockState(pos).isAir();
    }

    private void generateStem(LevelAccessor world, RandomSource random, BlockPos origin, Block vineBlock, int stemHeight, float berryChance) {
        BlockPos.MutableBlockPos stemPointer = origin.mutable();
        BlockState stemState = (BlockState)vineBlock.defaultBlockState().setValue(TriStateVineBlock.LIFE_STAGE, (Comparable)((Object)TriStateVineBlock.LifeStage.STALK));
        for (int height = 0; height <= stemHeight; ++height) {
            if (height == stemHeight) {
                if (berryChance > 0.0f && random.nextFloat() <= berryChance) {
                    this.setBlock((LevelWriter)world, (BlockPos)stemPointer, (BlockState)((BlockState)stemState.setValue(TriStateVineBlock.LIFE_STAGE, (Comparable)((Object)TriStateVineBlock.LifeStage.MATURE))).setValue((Property)BlockStateProperties.BERRIES, (Comparable)Boolean.valueOf(true)));
                } else {
                    this.setBlock((LevelWriter)world, (BlockPos)stemPointer, (BlockState)stemState.setValue(TriStateVineBlock.LIFE_STAGE, (Comparable)((Object)TriStateVineBlock.LifeStage.MATURE)));
                }
            } else if (berryChance > 0.0f && random.nextFloat() <= berryChance) {
                this.setBlock((LevelWriter)world, (BlockPos)stemPointer, (BlockState)stemState.setValue((Property)BlockStateProperties.BERRIES, (Comparable)Boolean.valueOf(true)));
            } else {
                this.setBlock((LevelWriter)world, (BlockPos)stemPointer, stemState);
            }
            stemPointer.move(Direction.DOWN);
        }
    }
}

