/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.blocks.jade_vines.NephriteBlossomLeavesBlock;
import earth.terrarium.pastel.blocks.jade_vines.NephriteBlossomStemBlock;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.worldgen.features.NephriteBlossomFeatureConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class NephriteBlossomFeature
extends Feature<NephriteBlossomFeatureConfig> {
    private static final List<Direction> VALID_DIRS = List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST);

    public NephriteBlossomFeature(Codec<NephriteBlossomFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<NephriteBlossomFeatureConfig> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BlockState floor = world.getBlockState(origin.below());
        Boolean flowering = ((NephriteBlossomFeatureConfig)context.config()).flowering();
        if (!floor.is(BlockTags.DIRT)) {
            return false;
        }
        int stemHeight = Math.round(Mth.normal((RandomSource)random, (float)2.0f, (float)1.0f) + 1.0f);
        int leafHeight = Math.round(Mth.normal((RandomSource)random, (float)2.5f, (float)0.9f) + 1.85f);
        int maxY = origin.getY() + stemHeight + leafHeight;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = origin.getY(); i < maxY; ++i) {
            pos.set(origin.getX(), i, origin.getZ());
            if (NephriteBlossomFeature.isReplaceable((LevelSimulatedReader)world, (BlockPos)pos)) continue;
            return false;
        }
        this.generateStem((LevelAccessor)world, origin, stemHeight);
        this.genereateLeaves((LevelAccessor)world, origin, random, stemHeight, leafHeight, flowering);
        return true;
    }

    private void generateStem(LevelAccessor world, BlockPos origin, int stemHeight) {
        BlockPos.MutableBlockPos stemPointer = origin.mutable();
        boolean topStem = false;
        for (int height = 0; height < stemHeight; ++height) {
            if (height == 0) {
                this.setBlock((LevelWriter)world, (BlockPos)stemPointer, ((Block)PastelBlocks.NEPHRITE_BLOSSOM_STEM.get()).defaultBlockState());
                topStem = true;
            } else if (NephriteBlossomFeature.isReplaceable((LevelSimulatedReader)world, (BlockPos)stemPointer)) {
                this.setBlock((LevelWriter)world, (BlockPos)stemPointer, NephriteBlossomStemBlock.getStemVariant(topStem));
                topStem = !topStem;
            }
            stemPointer.move(0, 1, 0);
        }
    }

    private void genereateLeaves(LevelAccessor world, BlockPos origin, RandomSource random, int stemHeight, int leafHeight, boolean flowering) {
        BlockPos.MutableBlockPos leafPointer = origin.mutable().move(0, stemHeight, 0);
        Direction leafDirection = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        for (int i = 0; i < leafHeight; ++i) {
            int leaf;
            for (leaf = 0; leaf < 4; ++leaf) {
                leafPointer.move(leafDirection);
                NephriteBlossomFeature.setBlockStateWithoutUpdatingNeighbors(world, (BlockPos)leafPointer, this.getLeafState(random, flowering));
                leafDirection = this.cycleDirections(leafDirection, 1);
            }
            if (i != 0 && i != leafHeight - 1) {
                leafDirection = leafDirection.getOpposite();
                for (leaf = 0; leaf < 4; ++leaf) {
                    leafPointer.move(leafDirection);
                    NephriteBlossomFeature.setBlockStateWithoutUpdatingNeighbors(world, (BlockPos)leafPointer, this.getLeafState(random, flowering));
                    leafDirection = this.cycleDirections(leafDirection, 1);
                }
                leafDirection = leafDirection.getOpposite();
            }
            leafPointer.move(0, 1, 0);
            if (!(random.nextBoolean() ^ i % 3 == 0)) continue;
            leafDirection = this.cycleDirections(leafDirection, random.nextInt(3) - 1);
        }
    }

    private static void setBlockStateWithoutUpdatingNeighbors(LevelAccessor world, BlockPos pos, BlockState state) {
        if (NephriteBlossomFeature.isReplaceable((LevelSimulatedReader)world, pos)) {
            world.setBlock(pos, state, 19);
        }
    }

    private BlockState getLeafState(RandomSource random, boolean allowFlowering) {
        BlockState state = (BlockState)((Block)PastelBlocks.NEPHRITE_BLOSSOM_LEAVES.get()).defaultBlockState().setValue((Property)NephriteBlossomLeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1));
        if (!allowFlowering) {
            return state;
        }
        if (random.nextBoolean()) {
            return (BlockState)state.setValue((Property)NephriteBlossomLeavesBlock.AGE, (Comparable)Integer.valueOf(1));
        }
        if (random.nextBoolean()) {
            return (BlockState)state.setValue((Property)NephriteBlossomLeavesBlock.AGE, (Comparable)Integer.valueOf(2));
        }
        return state;
    }

    private Direction cycleDirections(Direction currentDir, int change) {
        return this.getDirectionFor(this.getDirectionOridinal(currentDir) + Math.abs(change));
    }

    private Direction getDirectionFor(int ordinal) {
        return VALID_DIRS.get(ordinal % 4);
    }

    private int getDirectionOridinal(Direction direction) {
        return VALID_DIRS.indexOf(direction);
    }

    private static boolean isReplaceable(LevelSimulatedReader world, BlockPos pos) {
        return world.isStateAtPosition(pos, state -> state.isAir() || state.is(BlockTags.REPLACEABLE_BY_TREES));
    }
}

