/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableInt;

public class ExposedFossilFeature
extends Feature<FossilFeatureConfiguration> {
    public ExposedFossilFeature(Codec<FossilFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<FossilFeatureConfiguration> context) {
        Vec3i rotatedSize;
        BlockPos afterOffsetPos;
        BlockPos transformedPos;
        RandomSource random = context.random();
        WorldGenLevel structureWorldAccess = context.level();
        BlockPos origin = context.origin();
        Rotation blockRotation = Rotation.getRandom((RandomSource)random);
        FossilFeatureConfiguration fossilFeatureConfig = (FossilFeatureConfiguration)context.config();
        int fossilStructuresCount = random.nextInt(fossilFeatureConfig.fossilStructures.size());
        StructureTemplateManager structureTemplateManager = structureWorldAccess.getLevel().getServer().getStructureManager();
        StructureTemplate structureTemplate = structureTemplateManager.getOrCreate((ResourceLocation)fossilFeatureConfig.fossilStructures.get(fossilStructuresCount));
        StructureTemplate structureTemplate2 = structureTemplateManager.getOrCreate((ResourceLocation)fossilFeatureConfig.overlayStructures.get(fossilStructuresCount));
        ChunkPos originChunkPos = new ChunkPos(origin);
        BoundingBox blockBox = new BoundingBox(originChunkPos.getMinBlockX() - 16, structureWorldAccess.getMinBuildHeight(), originChunkPos.getMinBlockZ() - 16, originChunkPos.getMaxBlockX() + 16, structureWorldAccess.getMaxBuildHeight(), originChunkPos.getMaxBlockZ() + 16);
        StructurePlaceSettings structurePlacementData = new StructurePlaceSettings().setRotation(blockRotation).setBoundingBox(blockBox).setRandom(random);
        if (ExposedFossilFeature.getEmptyCorners(structureWorldAccess, structureTemplate.getBoundingBox(structurePlacementData, transformedPos = structureTemplate.getZeroPositionWithTransform(afterOffsetPos = origin.offset(-(rotatedSize = structureTemplate.getSize(blockRotation)).getX() / 2, 0, -rotatedSize.getZ() / 2), Mirror.NONE, blockRotation))) > fossilFeatureConfig.maxEmptyCornersAllowed) {
            return false;
        }
        structurePlacementData.clearProcessors();
        List processors = ((StructureProcessorList)fossilFeatureConfig.fossilProcessors.value()).list();
        Objects.requireNonNull(structurePlacementData);
        processors.forEach(arg_0 -> ((StructurePlaceSettings)structurePlacementData).addProcessor(arg_0));
        structureTemplate.placeInWorld((ServerLevelAccessor)structureWorldAccess, transformedPos, transformedPos, structurePlacementData, random, 4);
        structurePlacementData.clearProcessors();
        processors = ((StructureProcessorList)fossilFeatureConfig.overlayProcessors.value()).list();
        Objects.requireNonNull(structurePlacementData);
        processors.forEach(arg_0 -> ((StructurePlaceSettings)structurePlacementData).addProcessor(arg_0));
        structureTemplate2.placeInWorld((ServerLevelAccessor)structureWorldAccess, transformedPos, transformedPos, structurePlacementData, random, 4);
        return true;
    }

    private static int getEmptyCorners(WorldGenLevel world, BoundingBox box) {
        MutableInt mutableInt = new MutableInt(0);
        box.forAllCorners(pos -> {
            BlockState blockState = world.getBlockState(pos);
            if (blockState.isAir() || blockState.getBlock() instanceof LiquidBlock) {
                mutableInt.add(1);
            }
        });
        return mutableInt.getValue();
    }
}

