/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.status_effects;

import earth.terrarium.pastel.attachments.data.MiscPlayerData;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import earth.terrarium.pastel.registries.PastelEntityTypeTags;
import earth.terrarium.pastel.registries.PastelMobEffectTags;
import earth.terrarium.pastel.registries.PastelMobEffects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.EffectCure;
import org.jetbrains.annotations.Nullable;

public class SleepStatusEffect
extends MobEffect {
    private final boolean scales;

    public SleepStatusEffect(MobEffectCategory category, int color, boolean scales) {
        super(category, color);
        this.scales = scales;
    }

    public static float getSleepResistance(@Nullable MobEffectInstance sleepEffect, LivingEntity entity) {
        Player player;
        EntityType type = entity.getType();
        if (sleepEffect == null || type.is(PastelEntityTypeTags.SOULLESS)) {
            return Float.MAX_VALUE;
        }
        float scaling = entity instanceof Player && (player = (Player)entity).level().isClientSide() ? (float)MiscPlayerData.get(player).getLastSyncedSleepPotency() : (float)entity.getAttributeValue(PastelEntityAttributes.MENTAL_PRESENCE);
        if (type.is(PastelEntityTypeTags.SLEEP_WEAK)) {
            scaling /= 3.0f;
        } else if (type.is(PastelEntityTypeTags.SLEEP_RESISTANT)) {
            scaling *= 2.0f;
        } else if (SleepStatusEffect.isResistedBy(entity)) {
            scaling *= 10.0f;
        }
        return scaling;
    }

    public static boolean isResistedBy(LivingEntity entity) {
        if (entity.hasEffect(PastelMobEffects.FRENZY)) {
            return true;
        }
        EntityType type = entity.getType();
        if (type.is(PastelEntityTypeTags.SLEEP_WEAK)) {
            return false;
        }
        return type.is(PastelEntityTypeTags.SLEEP_IMMUNEISH) || SleepStatusEffect.isConstruct(type);
    }

    public static float getGeneralSleepResistanceIfEntityHasSoporificEffect(LivingEntity entity) {
        if (!SleepStatusEffect.isConstruct(entity.getType()) && PastelMobEffectTags.hasEffectWithTag(entity, PastelMobEffectTags.SOPORIFIC)) {
            return SleepStatusEffect.getSleepResistance(entity.getEffect(SleepStatusEffect.getStrongestSleepEffect(entity)), entity);
        }
        return -1.0f;
    }

    public static float getSleepScaling(LivingEntity entity) {
        if (entity == null) {
            return -1.0f;
        }
        float potency = SleepStatusEffect.getGeneralSleepResistanceIfEntityHasSoporificEffect(entity);
        if (potency == -1.0f || potency >= 1.0f) {
            return -1.0f;
        }
        return 2.0f * (float)Math.pow(1.0f - potency, 2.0);
    }

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
        Holder holder = effectInstance.getEffect();
        if (holder.equals(PastelMobEffects.SOMNOLENCE) || holder.equals(PastelMobEffects.CALMING)) {
            cures.add(PastelMobEffects.Cures.SEDATIVES);
        }
        cures.add(PastelMobEffects.Cures.BLOOD_ORCHID);
    }

    private static boolean isConstruct(EntityType<?> type) {
        return type.is(PastelEntityTypeTags.SOULLESS);
    }

    @Nullable
    public static Holder<MobEffect> getStrongestSleepEffect(LivingEntity entity) {
        if (entity.hasEffect(PastelMobEffects.FATAL_SLUMBER)) {
            return PastelMobEffects.FATAL_SLUMBER;
        }
        if (entity.hasEffect(PastelMobEffects.ETERNAL_SLUMBER)) {
            return PastelMobEffects.ETERNAL_SLUMBER;
        }
        if (entity.hasEffect(PastelMobEffects.SOMNOLENCE)) {
            return PastelMobEffects.SOMNOLENCE;
        }
        return null;
    }
}

