/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.status_effects;

import earth.terrarium.pastel.helpers.render.ParticleHelper;
import earth.terrarium.pastel.networking.s2c_payloads.PlayDivinityAppliedEffectsPayload;
import earth.terrarium.pastel.particle.VectorPattern;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelMobEffects;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.EffectCure;

public class DivinityStatusEffect
extends MobEffect {
    public static final int CIRCLET_AMPLIFIER = 0;
    public static final int ASCENSION_AMPLIFIER = 1;

    public DivinityStatusEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        boolean doEffects;
        Level world = entity.level();
        if (amplifier > 0 && world.isClientSide) {
            ParticleHelper.playParticleWithPatternAndVelocityClient(entity.level(), entity.position(), ColoredCraftingParticleEffect.RED, VectorPattern.EIGHT, 0.2);
        }
        boolean bl = doEffects = 40 >> amplifier == 0;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.isClientSide) {
                PastelCriteria.DIVINITY_TICK.trigger((ServerPlayer)player);
            }
            if (doEffects) {
                player.getFoodData().eat(1 + amplifier, 0.25f);
            }
        }
        if (doEffects && entity.getHealth() < entity.getMaxHealth()) {
            entity.heal((float)amplifier / 2.0f);
        }
        return super.applyEffectTick(entity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        super.onEffectStarted(entity, amplifier);
        if (entity instanceof Player && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            MobEffectInstance instance = entity.getEffect(PastelMobEffects.DIVINITY);
            if (instance != null && !instance.isAmbient()) {
                PlayDivinityAppliedEffectsPayload.playDivinityAppliedEffects(player);
            }
        }
    }

    public void removeAttributeModifiers(AttributeMap attributes) {
        super.removeAttributeModifiers(attributes);
    }
}

