/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import earth.terrarium.pastel.attachments.data.PrimordialFireData;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class OnPrimordialFireSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private final Player player;
    private int fadeInTicks;

    public OnPrimordialFireSoundInstance(Player player) {
        super(PastelSounds.PRIMORDIAL_FIRE_DOT, SoundSource.PLAYERS, player.getRandom());
        this.looping = true;
        this.delay = 0;
        this.volume = 0.05f;
        this.player = player;
        this.relative = true;
    }

    public void tick() {
        if (this.player != null) {
            this.pitch = (float)(1.0 + Math.sin((double)(this.player.tickCount % 240000) / 271.8281828459045) / 5.0);
        }
        this.volume = Mth.clampedLerp((float)0.05f, (float)0.92f, (float)((float)this.fadeInTicks / 20.0f));
        ++this.fadeInTicks;
    }

    public boolean isStopped() {
        return this.player == null || this.player.isRemoved() || !PrimordialFireData.isOnPrimordialFire((LivingEntity)this.player);
    }
}

