/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HintRevelationSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private final Player player;
    private boolean done;

    public HintRevelationSoundInstance(Player player) {
        super(PastelSounds.TEXT_REVEALED, SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.looping = true;
        this.delay = 0;
        this.volume = 1.0f;
        this.player = player;
        this.x = player.getX();
        this.y = player.getY();
        this.z = player.getZ();
    }

    public boolean isStopped() {
        return this.done;
    }

    public boolean canStartSilent() {
        return false;
    }

    public void tick() {
        if (this.player != null) {
            this.x = this.player.getX();
            this.y = this.player.getY();
            this.z = this.player.getZ();
        }
        if (this.player == null || !this.player.getMainHandItem().is((Item)PastelItems.GUIDEBOOK.get())) {
            this.setDone();
        }
    }

    public final void setDone() {
        this.done = true;
        this.looping = false;
    }
}

