/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import com.google.common.collect.HashMultimap;
import earth.terrarium.pastel.deeper_down.InterpMemory;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.render.ParticleHelper;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.sound.AuraData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AuraSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private static final Map<ResourceKey<Level>, HashMultimap<AuraSoundInstance, BlockPos>> LINKS = new HashMap<ResourceKey<Level>, HashMultimap<AuraSoundInstance, BlockPos>>();
    private static final float MIN_VOLUME = 0.005f;
    private final Level level;
    private final AuraData data;
    private final InterpMemory<Float> size = new InterpMemory();
    private Vec3 posMemory;
    private boolean discarded;

    private AuraSoundInstance(AuraData data, Level level) {
        super(data.sound(), SoundSource.AMBIENT, SoundInstance.createUnseededRandom());
        this.volume = 0.005f;
        this.looping = true;
        this.relative = true;
        this.level = level;
        this.data = data;
    }

    public void tick() {
        double proximity;
        Minecraft client = Minecraft.getInstance();
        long loop = this.level.getGameTime() % 10L;
        float delta = client.getTimer().getGameTimeDeltaPartialTick(true);
        Entity camera = client.cameraEntity;
        if (loop == 0L) {
            this.updateMembers();
        }
        if (this.discarded) {
            return;
        }
        float scaling = Mth.clampedLerp((float)this.size.last().floatValue(), (float)this.size.current().floatValue(), (float)(((float)loop + delta) / 10.0f));
        this.spawnParticles(scaling);
        if (camera == null) {
            this.discard();
            return;
        }
        if (this.data.pitchShift()) {
            this.pitchShift(camera);
        }
        if ((proximity = this.proximity(camera)) < (double)0.03f) {
            this.discard();
            return;
        }
        this.volume = (float)Mth.clamp((double)((double)scaling * proximity), (double)0.0, (double)0.995f) * this.data.volMult();
    }

    private void pitchShift(Entity camera) {
        double mod = Mth.clamp((double)((Math.abs(camera.getEyeY() - this.posMemory.y) - 6.0) / 196.0), (double)0.0, (double)0.225f);
        if (camera.getEyeY() < this.posMemory.y) {
            mod *= -1.0;
        }
        this.pitch = (float)(mod + 1.0);
    }

    private void spawnParticles(float scaling) {
        if (scaling > 0.01f) {
            float chance = scaling / 2.0f;
            ParticleHelper.playTriangulatedParticle(this.level, (ParticleOptions)PastelParticleTypes.AZURE_AURA, Support.chanceRound((double)chance * 2.25, this.random), true, new Vec3(24.0, 8.0, 24.0), -4.0, true, this.posMemory, new Vec3(0.0, 0.04 + this.random.nextDouble() * 0.06, 0.0));
            ParticleHelper.playTriangulatedParticle(this.level, (ParticleOptions)PastelParticleTypes.AZURE_MOTE_SMALL, Support.chanceRound(chance * 2.0f, this.random), false, new Vec3(16.0, 8.0, 16.0), -6.0, false, this.posMemory, Vec3.ZERO);
            ParticleHelper.playTriangulatedParticle(this.level, (ParticleOptions)PastelParticleTypes.AZURE_MOTE, Support.chanceRound(chance * 2.0f, this.random), true, new Vec3(16.0, 6.0, 16.0), -4.0, false, this.posMemory, Vec3.ZERO);
        }
    }

    private double proximity(Entity camera) {
        return Math.clamp(1.0 - camera.position().distanceTo(this.posMemory) / (double)this.data.maxDistance(), 0.0, 1.0);
    }

    private void updateMembers() {
        HashMultimap<AuraSoundInstance, BlockPos> auras = AuraSoundInstance.getLevelLinks(this.level);
        Set aura = auras.get((Object)this);
        if (aura.isEmpty()) {
            this.discarded = true;
            return;
        }
        BlockPos origin = (BlockPos)new ArrayList(aura).get(this.random.nextInt(aura.size()));
        ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
        this.floodTest(origin, checked, false);
        for (BlockPos proposal : checked) {
            this.updateOwnership(proposal, auras, aura);
        }
        aura.removeIf(b -> !checked.contains(b));
        if (aura.size() < this.data.min()) {
            this.discard();
            return;
        }
        this.updateScaling(aura);
    }

    private void updateScaling(Collection<BlockPos> newBlocks) {
        this.size.accept(Float.valueOf(Math.max((float)(newBlocks.size() - this.data.min()) / (float)this.data.scaling(), 0.005f)));
        double x = 0.5;
        double y = 0.5;
        double z = 0.5;
        for (BlockPos pos : newBlocks) {
            x += (double)pos.getX();
            y += (double)pos.getY();
            z += (double)pos.getZ();
        }
        this.posMemory = new Vec3(x / (double)newBlocks.size(), y / (double)newBlocks.size(), z / (double)newBlocks.size());
    }

    private void updateOwnership(BlockPos proposal, HashMultimap<AuraSoundInstance, BlockPos> auras, Set<BlockPos> aura) {
        Optional<AuraSoundInstance> parent = AuraSoundInstance.getOwner(auras, proposal);
        if (parent.filter(a -> a == this).isPresent() && this.data.filter().test(proposal, this.level)) {
            return;
        }
        if (parent.isEmpty()) {
            aura.add(proposal);
            return;
        }
        aura.remove(proposal);
    }

    private void floodTest(BlockPos current, List<BlockPos> out, boolean sanitize) {
        BlockPos.betweenClosedStream((int)(current.getX() - 1), (int)(current.getY() - 1), (int)(current.getZ() - 1), (int)(current.getX() + 1), (int)(current.getY() + 1), (int)(current.getZ() + 1)).map(BlockPos::immutable).filter(b -> !out.contains(b)).filter(b -> !sanitize || AuraSoundInstance.getOwner(AuraSoundInstance.getLevelLinks(this.level), b).isEmpty()).filter(b -> this.data.filter().test((BlockPos)b, this.level)).peek(out::add).forEach(b -> this.floodTest((BlockPos)b, out, sanitize));
    }

    public boolean isStopped() {
        return this.discarded;
    }

    private void discard() {
        AuraSoundInstance.getLevelLinks(this.level).removeAll((Object)this);
        this.discarded = true;
    }

    public static void getOrCreateInstance(AuraData data, Level level, BlockPos pos) {
        HashMultimap<AuraSoundInstance, BlockPos> links = AuraSoundInstance.getLevelLinks(level);
        Optional<AuraSoundInstance> check = AuraSoundInstance.getOwner(links, pos);
        if (check.isPresent()) {
            return;
        }
        AuraSoundInstance aura = new AuraSoundInstance(data, level);
        ArrayList<BlockPos> proposed = new ArrayList<BlockPos>();
        aura.floodTest(pos, proposed, true);
        if (proposed.size() <= data.min()) {
            return;
        }
        proposed.forEach(b -> links.put((Object)aura, b));
        aura.updateScaling(proposed);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)aura);
    }

    @NotNull
    private static HashMultimap<AuraSoundInstance, BlockPos> getLevelLinks(Level level) {
        return LINKS.computeIfAbsent((ResourceKey<Level>)level.dimension(), l -> HashMultimap.create());
    }

    private static Optional<AuraSoundInstance> getOwner(HashMultimap<AuraSoundInstance, BlockPos> levelAuras, BlockPos pos) {
        for (Map.Entry entry : levelAuras.entries()) {
            if (!((BlockPos)entry.getValue()).equals((Object)pos)) continue;
            return Optional.ofNullable((AuraSoundInstance)((Object)entry.getKey()));
        }
        return Optional.empty();
    }

    public static void clear() {
        for (Map.Entry<ResourceKey<Level>, HashMultimap<AuraSoundInstance, BlockPos>> entry : LINKS.entrySet()) {
            for (AuraSoundInstance aura : entry.getValue().keySet()) {
                aura.discarded = true;
            }
        }
        LINKS.clear();
    }
}

