/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.render.item;

import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.IItemDecorator;
import org.jetbrains.annotations.Nullable;

public class SlotEffectDecorator
implements IItemDecorator {
    public boolean render(GuiGraphics g, Font font, ItemStack stack, int x, int y) {
        SlotBackgroundEffect background = SlotEffectDecorator.getEffect(stack);
        ExtendedItemBar bar = SlotEffectDecorator.getBar(stack);
        boolean drawn = false;
        if (background != null) {
            drawn = SlotEffectDecorator.renderBackground(g, stack, x, y, background);
        }
        if (bar != null) {
            drawn = SlotEffectDecorator.renderBar(g, stack, x, y, bar) || drawn;
        }
        return drawn;
    }

    private static boolean renderBar(GuiGraphics g, ItemStack stack, int x, int y, ExtendedItemBar bar) {
        if (bar.barCount(stack) == 0) {
            return false;
        }
        boolean rendered = false;
        for (int i = 0; i < bar.barCount(stack); ++i) {
            ExtendedItemBar.BarSignature signature = bar.getSignature((Player)Minecraft.getInstance().player, stack, i);
            if (signature == ExtendedItemBar.PASS) continue;
            int k = x + signature.xPos();
            int l = y + signature.yPos();
            g.fill(RenderType.guiOverlay(), k, l, k + signature.length(), l + signature.backgroundHeight(), signature.backgroundColor());
            g.fill(RenderType.guiOverlay(), k, l, k + signature.fill(), l + signature.fillHeight(), signature.fillColor());
            rendered = true;
        }
        return rendered;
    }

    private static boolean renderBackground(GuiGraphics g, ItemStack stack, int x, int y, SlotBackgroundEffect backgroundEffectProvider) {
        LocalPlayer player = Minecraft.getInstance().player;
        float delta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        SlotBackgroundEffect.SlotEffect type = backgroundEffectProvider.backgroundType((Player)player, stack);
        float opacity = backgroundEffectProvider.getEffectOpacity((Player)player, stack, delta);
        int color = backgroundEffectProvider.getBackgroundColor((Player)player, stack, delta) & 0xFFFFFF | Math.round(opacity * 255.0f) << 24;
        int transColor = color & 0xFFFFFF;
        long time = Minecraft.getInstance().player.level().getGameTime() % 864000L;
        double bounce = Math.sin(((float)time + delta) / 20.0f) * (double)0.4f + 0.5;
        int alpha = (int)Math.round(bounce * 255.0);
        switch (type) {
            case NONE: {
                return false;
            }
            case BORDER_FADE: {
                g.fillGradient(x, y, x + 1, y + 15, transColor, color);
                g.fillGradient(x + 15, y, x + 16, y + 15, transColor, color);
                g.fillGradient(x, y + 15, x + 16, y + 16, color, color);
                break;
            }
            case FULL_PACKAGE: 
            case PULSE: {
                g.fillGradient(x, y, x + 16, y + 16, transColor, transColor | alpha << 24);
                if (type == SlotBackgroundEffect.SlotEffect.PULSE) break;
            }
            case BORDER: {
                g.renderOutline(x, y, 16, 16, color);
            }
        }
        return true;
    }

    @Nullable
    private static SlotBackgroundEffect getEffect(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.getItem();
        if (item instanceof SlotBackgroundEffect) {
            SlotBackgroundEffect prov = (SlotBackgroundEffect)item;
            return prov;
        }
        item = stack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof SlotBackgroundEffect) {
            SlotBackgroundEffect prov = (SlotBackgroundEffect)item;
            return prov;
        }
        return null;
    }

    @Nullable
    private static ExtendedItemBar getBar(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ExtendedItemBar) {
            ExtendedItemBar bar = (ExtendedItemBar)item;
            return bar;
        }
        return null;
    }
}

