/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.render.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;

public class BedrockArmorModel
extends HumanoidModel<LivingEntity> {
    final EquipmentSlot slot;

    public BedrockArmorModel(ModelPart root, EquipmentSlot slot) {
        super(root);
        this.slot = slot;
    }

    public static MeshDefinition getModelData() {
        MeshDefinition data = new MeshDefinition();
        PartDefinition root = data.getRoot();
        root.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -8.625f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.3f)), PartPose.ZERO);
        PartDefinition head_plume = head.addOrReplaceChild("head_plume", CubeListBuilder.create().texOffs(38, 61).addBox(0.0f, -0.0806f, 0.1517f, 0.0f, 11.0f, 7.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-11.25f, (float)2.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition visor = head.addOrReplaceChild("visor", CubeListBuilder.create().texOffs(30, 11).addBox(-5.0f, -3.0f, -6.8f, 10.0f, 5.0f, 7.0f, new CubeDeformation(0.125f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)1.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition visor_frill_left = visor.addOrReplaceChild("visor_frill_left", CubeListBuilder.create().texOffs(38, 14).addBox(1.25f, -4.0f, -4.5f, 0.0f, 8.0f, 9.0f, new CubeDeformation(0.0f, 0.125f, 0.125f)), PartPose.offsetAndRotation((float)5.1f, (float)-2.0f, (float)1.2f, (float)0.5796f, (float)0.2344f, (float)0.1939f));
        PartDefinition visor_frill_right = visor.addOrReplaceChild("visor_frill_right", CubeListBuilder.create().texOffs(56, 14).addBox(-1.25f, -4.0f, -4.5f, 0.0f, 8.0f, 9.0f, new CubeDeformation(0.0f, 0.125f, 0.125f)), PartPose.offsetAndRotation((float)-5.1f, (float)-2.0f, (float)1.2f, (float)0.5796f, (float)-0.2344f, (float)-0.1939f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 31).addBox(-4.5f, -1.0f, -2.5f, 9.0f, 13.0f, 5.0f, new CubeDeformation(0.25f)).texOffs(28, 41).addBox(-4.5f, -1.0f, -3.75f, 9.0f, 12.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.5f, (float)0.5f));
        PartDefinition body_roll = body.addOrReplaceChild("body_roll", CubeListBuilder.create().texOffs(28, 31).addBox(-5.5f, -3.5f, -1.25f, 12.0f, 5.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.5f, (float)1.5f, (float)2.5f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition body_collar = body.addOrReplaceChild("body_collar", CubeListBuilder.create().texOffs(0, 83).addBox(-4.5f, -1.5f, -4.25f, 9.0f, 5.0f, 7.0f, new CubeDeformation(0.25f)).texOffs(0, 18).addBox(-5.5f, -1.5f, -5.25f, 11.0f, 5.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(18, 56).addBox(-4.0f, -1.5f, -2.5f, 5.0f, 12.0f, 5.0f, new CubeDeformation(0.175f)).texOffs(56, 35).addBox(-4.5f, -1.5f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.175f)), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm_pauldron_top = right_arm.addOrReplaceChild("right_arm_pauldron_top", CubeListBuilder.create().texOffs(74, 22).addBox(1.0f, -1.0f, -2.5f, 2.0f, 5.0f, 7.0f, CubeDeformation.NONE).texOffs(57, 3).addBox(-4.0f, 0.0f, -2.5f, 5.0f, 4.0f, 7.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-3.0f, (float)-2.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition left_arm = root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(47, 51).addBox(-1.0f, -2.0f, -2.5f, 5.0f, 12.0f, 5.0f, new CubeDeformation(0.175f)).texOffs(16, 73).addBox(0.5f, 0.0f, -3.0f, 4.0f, 5.0f, 6.0f, new CubeDeformation(0.175f)), PartPose.offset((float)4.0f, (float)2.5f, (float)0.0f));
        PartDefinition left_arm_bauldron_top = left_arm.addOrReplaceChild("left_arm_bauldron_top", CubeListBuilder.create().texOffs(74, 0).addBox(-0.5f, -5.0f, -3.0f, 5.0f, 1.0f, 6.0f, CubeDeformation.NONE).texOffs(36, 0).addBox(-1.5f, -4.0f, -3.5f, 7.0f, 3.0f, 7.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg_armor = left_leg.addOrReplaceChild("left_leg_armor", CubeListBuilder.create().texOffs(67, 47).addBox(-2.5f, -0.5f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.ZERO);
        PartDefinition left_boot = left_leg.addOrReplaceChild("left_boot", CubeListBuilder.create().texOffs(82, 42).addBox(-2.5f, 9.25f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.1f)).texOffs(32, 80).mirror().addBox(-2.25f, 5.0f, -1.25f, 5.0f, 6.0f, 4.0f, new CubeDeformation(0.125f)).mirror(false), PartPose.ZERO);
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_leg_armor = right_leg.addOrReplaceChild("right_leg_armor", CubeListBuilder.create().texOffs(62, 63).addBox(-2.5f, -0.5f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.ZERO);
        PartDefinition right_boot = right_leg.addOrReplaceChild("right_boot", CubeListBuilder.create().texOffs(32, 80).addBox(-2.75f, 5.0f, -1.25f, 5.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)).texOffs(80, 34).addBox(-2.5f, 9.25f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.125f)), PartPose.ZERO);
        return data;
    }

    public void prepareMobModel(LivingEntity livingEntity, float f, float g, float h) {
        super.prepareMobModel(livingEntity, f, g, h);
    }

    public void setupAnim(LivingEntity entity, float f, float g, float h, float i, float j) {
        if (!(entity instanceof ArmorStand)) {
            super.setupAnim(entity, f, g, h, i, j);
            return;
        }
        ArmorStand stand = (ArmorStand)entity;
        this.head.xRot = (float)Math.PI / 180 * stand.getHeadPose().getX();
        this.head.yRot = (float)Math.PI / 180 * stand.getHeadPose().getY();
        this.head.zRot = (float)Math.PI / 180 * stand.getHeadPose().getZ();
        this.head.setPos(0.0f, 1.0f, 0.0f);
        this.body.xRot = (float)Math.PI / 180 * stand.getBodyPose().getX();
        this.body.yRot = (float)Math.PI / 180 * stand.getBodyPose().getY();
        this.body.zRot = (float)Math.PI / 180 * stand.getBodyPose().getZ();
        this.leftArm.xRot = (float)Math.PI / 180 * stand.getLeftArmPose().getX();
        this.leftArm.yRot = (float)Math.PI / 180 * stand.getLeftArmPose().getY();
        this.leftArm.zRot = (float)Math.PI / 180 * stand.getLeftArmPose().getZ();
        this.rightArm.xRot = (float)Math.PI / 180 * stand.getRightArmPose().getX();
        this.rightArm.yRot = (float)Math.PI / 180 * stand.getRightArmPose().getY();
        this.rightArm.zRot = (float)Math.PI / 180 * stand.getRightArmPose().getZ();
        this.leftLeg.xRot = (float)Math.PI / 180 * stand.getLeftLegPose().getX();
        this.leftLeg.yRot = (float)Math.PI / 180 * stand.getLeftLegPose().getY();
        this.leftLeg.zRot = (float)Math.PI / 180 * stand.getLeftLegPose().getZ();
        this.leftLeg.setPos(1.9f, 11.0f, 0.0f);
        this.rightLeg.xRot = (float)Math.PI / 180 * stand.getRightLegPose().getX();
        this.rightLeg.yRot = (float)Math.PI / 180 * stand.getRightLegPose().getY();
        this.rightLeg.zRot = (float)Math.PI / 180 * stand.getRightLegPose().getZ();
        this.rightLeg.setPos(-1.9f, 11.0f, 0.0f);
        this.hat.copyFrom(this.head);
    }

    public void renderToBuffer(PoseStack ms, VertexConsumer buffer, int light, int overlay, int color) {
        this.renderArmorPart(this.slot);
        super.renderToBuffer(ms, buffer, light, overlay, color);
    }

    public static Tuple<Float, Float> computeFrontClothRotation(LivingEntity entity, float delta) {
        if (!(entity instanceof Player)) {
            return new Tuple((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
        Player player = (Player)entity;
        double x = Mth.lerp((double)(delta / 2.0f), (double)player.xCloakO, (double)player.xCloak) - Mth.lerp((double)(delta / 2.0f), (double)player.xo, (double)player.getX());
        double y = Mth.lerp((double)(delta / 2.0f), (double)player.yCloakO, (double)player.yCloak) - Mth.lerp((double)(delta / 2.0f), (double)player.yo, (double)player.getY());
        double z = Mth.lerp((double)(delta / 2.0f), (double)player.zCloakO, (double)player.zCloak) - Mth.lerp((double)(delta / 2.0f), (double)player.zo, (double)player.getZ());
        float yaw = Mth.rotLerp((float)delta, (float)player.yBodyRotO, (float)player.yBodyRot);
        double o = Mth.sin((float)(yaw * ((float)Math.PI / 180)));
        double p = -Mth.cos((float)(yaw * ((float)Math.PI / 180)));
        float q = (float)y * 10.0f;
        q = Mth.clamp((float)q, (float)-2.0f, (float)24.0f);
        float r = (float)(x * o + z * p) * 100.0f;
        r = Mth.clamp((float)r, (float)0.0f, (float)150.0f);
        float capeZOffset = (float)(x * p - z * o) * 100.0f;
        capeZOffset = Mth.clamp((float)capeZOffset, (float)-20.0f, (float)20.0f);
        if (r < 0.0f) {
            r = 0.0f;
        }
        float t = Mth.lerp((float)delta, (float)player.oBob, (float)player.bob);
        q += Mth.sin((float)(Mth.lerp((float)delta, (float)player.walkDistO, (float)player.walkDist) * 6.0f)) * 32.0f * t;
        if (player.isCrouching()) {
            q += 25.0f;
        }
        return new Tuple((Object)Float.valueOf(-(6.0f + r / 2.0f + q)), (Object)Float.valueOf(capeZOffset));
    }

    private void renderArmorPart(EquipmentSlot slot) {
        this.setAllVisible(false);
        this.rightLeg.getChild((String)"right_leg_armor").visible = false;
        this.leftLeg.getChild((String)"left_leg_armor").visible = false;
        this.rightLeg.getChild((String)"right_boot").visible = false;
        this.leftLeg.getChild((String)"left_boot").visible = false;
        switch (slot) {
            case HEAD: {
                this.head.visible = true;
                break;
            }
            case CHEST: {
                this.body.visible = true;
                this.rightArm.visible = true;
                this.leftArm.visible = true;
                break;
            }
            case LEGS: {
                this.rightLeg.visible = true;
                this.leftLeg.visible = true;
                this.rightLeg.getChild((String)"right_leg_armor").visible = true;
                this.leftLeg.getChild((String)"left_leg_armor").visible = true;
                break;
            }
            case FEET: {
                this.rightLeg.visible = true;
                this.leftLeg.visible = true;
                this.rightLeg.getChild((String)"right_boot").visible = true;
                this.leftLeg.getChild((String)"left_boot").visible = true;
                break;
            }
        }
    }
}

