/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeData;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeProvider;
import earth.terrarium.pastel.attachments.data.azure_dike.DikeShieldData;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@OnlyIn(value=Dist.CLIENT)
public class HudRenderers {
    public static final ResourceLocation PLAYER_DIKE = PastelCommon.locate("player_dike");
    private static final Component missingInkText = Component.translatable((String)"item.pastel.constructors_staff.tooltip.missing_ink");
    private static final Component noneText = Component.translatable((String)"item.pastel.constructors_staff.tooltip.none_in_inventory");
    private static ItemStack itemStackToRender;
    private static int amount;
    private static boolean missingInk;
    private static final int DIKE_HEARTS_PER_ROW = 10;
    private static final int DIKE_PER_ROW = 20;

    public static void registerLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.PLAYER_HEALTH, PLAYER_DIKE, (LayeredDraw.Layer)new AzureDikeLayer());
    }

    public static void registerInjects(RenderGuiLayerEvent.Post event) {
        if (event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            HudRenderers.renderSelectedStaffStack(event.getGuiGraphics());
        }
    }

    private static void renderSelectedStaffStack(GuiGraphics gui) {
        Minecraft client = Minecraft.getInstance();
        if (amount > -1 && itemStackToRender != null) {
            Window window = Minecraft.getInstance().getWindow();
            int x = window.getGuiScaledWidth() / 2 + 3;
            int y = window.getGuiScaledHeight() / 2 + 3;
            PoseStack poseStack = gui.pose();
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 1.0f);
            Font textRenderer = client.font;
            gui.renderItem(itemStackToRender, (x + 8) * 2, (y + 8) * 2);
            poseStack.scale(2.0f, 2.0f, 1.0f);
            gui.drawString(textRenderer, itemStackToRender.getHoverName(), x + 18, y + 8, 0xFFFFFF, false);
            if (amount == 0) {
                gui.drawString(textRenderer, noneText, x + 18, y + 19, 0xDDDDDD, false);
            } else if (missingInk) {
                gui.drawString(textRenderer, missingInkText, x + 18, y + 19, 0xDDDDDD, false);
            } else {
                gui.drawString(textRenderer, amount + "x", x + 18, y + 19, 0xDDDDDD, false);
            }
            poseStack.popPose();
        }
    }

    public static void setItemStackToRender(ItemStack itemStack, int amount, boolean missingInk) {
        itemStackToRender = itemStack;
        HudRenderers.amount = amount;
        HudRenderers.missingInk = missingInk;
    }

    public static void clearItemStackOverlay() {
        amount = -1;
    }

    private static class AzureDikeLayer
    implements LayeredDraw.Layer {
        private AzureDikeLayer() {
        }

        public void render(GuiGraphics gui, DeltaTracker deltaTracker) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft.options.hideGui || minecraft.gameMode == null || !minecraft.gameMode.canHurtPlayer()) {
                return;
            }
            LocalPlayer cameraPlayer = Minecraft.getInstance().player;
            int x = gui.guiWidth() / 2 - 91;
            int y = gui.guiHeight() - Minecraft.getInstance().gui.leftHeight;
            AzureDikeData azureDikeComponent = AzureDikeProvider.getAzureDikeComponent((LivingEntity)cameraPlayer);
            int maxCharges = (int)Math.ceil(azureDikeComponent.getMaxProtection());
            if (maxCharges > 0) {
                int i;
                int charges = (int)Math.ceil(azureDikeComponent.getCurrentProtection());
                boolean blink = false;
                if (cameraPlayer.getLastDamageSource() != null && cameraPlayer.invulnerableTime / 3 > 0) {
                    blink = (cameraPlayer.level().getGameTime() >> 2) % 2L == 0L;
                }
                int totalDikeCanisters = (maxCharges - 1) / 20;
                int filledDikeCanisters = (charges - 1) / 20;
                int displayedDike = (charges - 1) % 20 + 1;
                int dikeHeartOutlinesThisRow = totalDikeCanisters > filledDikeCanisters ? 10 : (maxCharges - 1) % 20 / 2 + 1;
                boolean renderBackRow = filledDikeCanisters > 0;
                boolean hasArmor = cameraPlayer.getArmorValue() > 0;
                ResourceLocation texture = DikeShieldData.AZURE_DIKE_BAR_TEXTURE;
                x += PastelCommon.CONFIG.AzureDikeHudOffsetX;
                y += hasArmor ? PastelCommon.CONFIG.AzureDikeHudOffsetYWithArmor : PastelCommon.CONFIG.AzureDikeHudOffsetY;
                RenderSystem.enableBlend();
                if (renderBackRow) {
                    for (i = displayedDike / 2; i < 10; ++i) {
                        gui.blit(texture, x + i * 8, y, 36.0f, 9.0f, 9, 9, 256, 256);
                    }
                }
                for (i = 0; i < dikeHeartOutlinesThisRow; ++i) {
                    if (renderBackRow) {
                        if (blink) {
                            gui.blit(texture, x + i * 8, y, 54.0f, 9.0f, 9, 9, 256, 256);
                            continue;
                        }
                        gui.blit(texture, x + i * 8, y, 45.0f, 9.0f, 9, 9, 256, 256);
                        continue;
                    }
                    if (blink) {
                        gui.blit(texture, x + i * 8, y, 9.0f, 9.0f, 9, 9, 256, 256);
                        continue;
                    }
                    gui.blit(texture, x + i * 8, y, 0.0f, 9.0f, 9, 9, 256, 256);
                }
                for (i = 0; i < displayedDike; i += 2) {
                    if (i + 1 < displayedDike) {
                        gui.blit(texture, x + i * 4, y, 18.0f, 9.0f, 9, 9, 256, 256);
                        continue;
                    }
                    gui.blit(texture, x + i * 4, y, 27.0f, 9.0f, 9, 9, 256, 256);
                }
                for (i = 0; i < filledDikeCanisters; ++i) {
                    gui.blit(texture, x + i * 6, y - 9, 0.0f, 0.0f, 9, 9, 256, 256);
                }
                for (i = filledDikeCanisters; i < totalDikeCanisters; ++i) {
                    gui.blit(texture, x + i * 6, y - 9, 9.0f, 0.0f, 9, 9, 256, 256);
                }
                RenderSystem.disableBlend();
            }
        }
    }
}

