/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries.client;

import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.storage.SingleInkStorage;
import earth.terrarium.pastel.api.entity.PlayerEntityAccessor;
import earth.terrarium.pastel.api.item.ActivatableItem;
import earth.terrarium.pastel.api.item.SlotReservingItem;
import earth.terrarium.pastel.blocks.bottomless_bundle.BottomlessBundleItem;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.components.WrappedPresentComponent;
import earth.terrarium.pastel.items.energy.InkFlaskItem;
import earth.terrarium.pastel.items.magic_items.EnderSpliceItem;
import earth.terrarium.pastel.items.magic_items.PipeBombItem;
import earth.terrarium.pastel.items.magic_items.StructureCompassItem;
import earth.terrarium.pastel.items.tools.MalachiteCrossbowItem;
import earth.terrarium.pastel.items.tools.PastelFishingRodItem;
import earth.terrarium.pastel.items.trinkets.AshenCircletItem;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;

public class PastelModelPredicateProviders {
    public static void registerClient(FMLClientSetupEvent event) {
        PastelModelPredicateProviders.registerBowPredicates((Item)PastelItems.BEDROCK_BOW.get());
        PastelModelPredicateProviders.registerCrossbowPredicates((Item)PastelItems.BEDROCK_CROSSBOW.get());
        PastelModelPredicateProviders.registerSpectrumFishingRodItemPredicates((Item)PastelItems.LAGOON_ROD.get());
        PastelModelPredicateProviders.registerSpectrumFishingRodItemPredicates((Item)PastelItems.MOLTEN_ROD.get());
        PastelModelPredicateProviders.registerSpectrumFishingRodItemPredicates((Item)PastelItems.BEDROCK_FISHING_ROD.get());
        PastelModelPredicateProviders.registerEnderSplicePredicates((Item)PastelItems.ENDER_SPLICE.get());
        PastelModelPredicateProviders.registerAnimatedWandPredicates((Item)PastelItems.NATURES_STAFF.get());
        PastelModelPredicateProviders.registerAnimatedWandPredicates((Item)PastelItems.RADIANCE_STAFF.get());
        PastelModelPredicateProviders.registerAnimatedWandPredicates((Item)PastelItems.STAFF_OF_REMEMBRANCE.get());
        PastelModelPredicateProviders.registerKnowledgeDropPredicates((Item)PastelItems.KNOWLEDGE_GEM.get());
        PastelModelPredicateProviders.registerAshenCircletPredicates((Item)PastelItems.ASHEN_CIRCLET.get());
        PastelModelPredicateProviders.registerNullableInkColorPredicate((Item)PastelItems.INK_FLASK.get());
        PastelModelPredicateProviders.registerInkFillStateItemPredicate((Item)PastelItems.INK_FLASK.get());
        PastelModelPredicateProviders.registerMoonPhasePredicates((Item)PastelItems.CRESCENT_CLOCK.get());
        PastelModelPredicateProviders.registerActivatableItemPredicate((Item)PastelItems.DREAMFLAYER.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.DREAMFLAYER.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.KNOTTED_SWORD.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.NECTAR_LANCE.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.BEDROCK_SWORD.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.BEDROCK_AXE.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.PAINTBRUSH.get());
        PastelModelPredicateProviders.registerStampingItemPredicate((Item)PastelItems.TUNING_STAMP.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.DRACONIC_TWINSWORD.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.DRAGON_TALON.get());
        PastelModelPredicateProviders.registerSlotReservingItem((Item)PastelItems.DRAGON_TALON.get());
        PastelModelPredicateProviders.registerSlotReservingItem((Item)PastelItems.DRACONIC_TWINSWORD.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.MALACHITE_WORKSTAFF.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.MALACHITE_ULTRA_GREATSWORD.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.MALACHITE_CROSSBOW.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.MALACHITE_BIDENT.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.GLASS_CREST_WORKSTAFF.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.GLASS_CREST_ULTRA_GREATSWORD.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.GLASS_CREST_CROSSBOW.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.FEROCIOUS_GLASS_CREST_BIDENT.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.FRACTAL_GLASS_CREST_BIDENT.get());
        PastelModelPredicateProviders.registerOversizedItemPredicate((Item)PastelItems.OMNI_ACCELERATOR.get());
        PastelModelPredicateProviders.registerBidentThrowingItemPredicate((Item)PastelItems.MALACHITE_BIDENT.get());
        PastelModelPredicateProviders.registerBidentThrowingItemPredicate((Item)PastelItems.FEROCIOUS_GLASS_CREST_BIDENT.get());
        PastelModelPredicateProviders.registerBidentThrowingItemPredicate((Item)PastelItems.FRACTAL_GLASS_CREST_BIDENT.get());
        PastelModelPredicateProviders.registerMalachiteCrossbowPredicates((Item)PastelItems.MALACHITE_CROSSBOW.get());
        PastelModelPredicateProviders.registerMalachiteCrossbowPredicates((Item)PastelItems.GLASS_CREST_CROSSBOW.get());
        PastelModelPredicateProviders.registerBottomlessBundlePredicates(((Block)PastelBlocks.BOTTOMLESS_BUNDLE.get()).asItem());
        PastelModelPredicateProviders.registerEnchantmentCanvasPredicates((Item)PastelItems.ENCHANTMENT_CANVAS.get());
        PastelModelPredicateProviders.registerPresentPredicates(((Block)PastelBlocks.PRESENT.get()).asItem());
        PastelModelPredicateProviders.registerMysteriousLocketPredicates((Item)PastelItems.MYSTERIOUS_LOCKET.get());
        PastelModelPredicateProviders.registerStructureCompassPredicates((Item)PastelItems.MYSTERIOUS_COMPASS.get());
        PastelModelPredicateProviders.registerPipeBombPredicates((Item)PastelItems.PIPE_BOMB.get());
    }

    private static void registerStampingItemPredicate(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"stamped"), (stack, world, entity, seed) -> {
            CustomData nbt = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            if (nbt.contains("pastel:stamping_data")) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    private static void registerNullableInkColorPredicate(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"color"), (stack, clientWorld, entity, i) -> {
            InkColor color = (InkColor)stack.get(PastelDataComponentTypes.INK_COLOR);
            return color == null ? -1.0f : (float)color.getColorInt();
        });
    }

    private static void registerMysteriousLocketPredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"socketed"), (stack, world, entity, i) -> stack.has(PastelDataComponentTypes.SOCKETED) ? 1.0f : 0.0f);
    }

    private static void registerStructureCompassPredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((world, stack, entity) -> StructureCompassItem.getStructurePos(stack)));
    }

    private static void registerMalachiteCrossbowPredicates(Item crossbowItem) {
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)ResourceLocation.parse((String)"pull"), (stack, world, user, i) -> user == null || CrossbowItem.isCharged((ItemStack)stack) ? 0.0f : (float)(stack.getUseDuration(user) - user.getUseItemRemainingTicks()) / (float)CrossbowItem.getChargeDuration((ItemStack)stack, (LivingEntity)user));
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)ResourceLocation.parse((String)"pulling"), (stack, world, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack && !CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)ResourceLocation.parse((String)"charged"), (stack, world, entity, i) -> entity != null && CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)ResourceLocation.parse((String)"projectile"), (stack, world, entity, seed) -> {
            if (stack == null) {
                return 0.0f;
            }
            ItemStack projectile = MalachiteCrossbowItem.getFirstProjectile(stack);
            if (projectile.isEmpty()) {
                return 0.0f;
            }
            if (projectile.is(Items.FIREWORK_ROCKET)) {
                return 0.1f;
            }
            if (projectile.is((Item)PastelItems.MALACHITE_GLASS_ARROW.get())) {
                return 0.2f;
            }
            if (projectile.is((Item)PastelItems.TOPAZ_GLASS_ARROW.get())) {
                return 0.3f;
            }
            if (projectile.is((Item)PastelItems.AMETHYST_GLASS_ARROW.get())) {
                return 0.4f;
            }
            if (projectile.is((Item)PastelItems.CITRINE_GLASS_ARROW.get())) {
                return 0.5f;
            }
            if (projectile.is((Item)PastelItems.ONYX_GLASS_ARROW.get())) {
                return 0.6f;
            }
            if (projectile.is((Item)PastelItems.MOONSTONE_GLASS_ARROW.get())) {
                return 0.7f;
            }
            return 0.0f;
        });
    }

    private static void registerBidentThrowingItemPredicate(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"bident_throwing"), (stack, world, entity, seed) -> {
            if (seed == 80085) {
                return 1.0f;
            }
            return entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 0.5f : 0.0f;
        });
    }

    private static void registerPresentPredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"variant"), (stack, world, entity, i) -> (float)((WrappedPresentComponent)stack.getOrDefault(PastelDataComponentTypes.WRAPPED_PRESENT, (Object)WrappedPresentComponent.DEFAULT)).variant().ordinal() / 10.0f);
    }

    private static void registerBottomlessBundlePredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"locked"), (stack, world, entity, i) -> BottomlessBundleItem.isLocked(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"filled"), (stack, world, entity, i) -> BottomlessBundleItem.getStoredAmount(stack) > 0L ? 1.0f : 0.0f);
    }

    private static void registerMoonPhasePredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"phase"), (stack, world, entity, i) -> {
            Level patt0$temp;
            LivingEntity holder;
            Object object = holder = entity != null ? entity : stack.getEntityRepresentation();
            if (holder == null) {
                return 0.0f;
            }
            if (world == null && (patt0$temp = holder.level()) instanceof ClientLevel) {
                ClientLevel clientWorld;
                world = clientWorld = (ClientLevel)patt0$temp;
            }
            if (world == null) {
                return 0.0f;
            }
            if (!world.dimensionType().natural()) {
                return 1.0f;
            }
            return (float)world.getMoonPhase() / 8.0f;
        });
    }

    private static void registerActivatableItemPredicate(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"activated"), (stack, world, entity, i) -> ActivatableItem.isActivated(stack) ? 1.0f : 0.0f);
    }

    private static void registerSlotReservingItem(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"reserved"), (stack, world, entity, i) -> SlotReservingItem.isReservingSlot(stack) ? 1.0f : 0.0f);
    }

    private static void registerOversizedItemPredicate(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"oversized"), (stack, world, entity, seed) -> seed == 817210941 || seed == 80085 ? 1.0f : 0.0f);
    }

    private static void registerBowPredicates(Item bowItem) {
        ItemProperties.register((Item)bowItem, (ResourceLocation)ResourceLocation.parse((String)"pull"), (stack, world, entity, i) -> entity == null || entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f);
        ItemProperties.register((Item)bowItem, (ResourceLocation)ResourceLocation.parse((String)"pulling"), (stack, world, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
    }

    private static void registerCrossbowPredicates(Item crossbowItem) {
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)ResourceLocation.parse((String)"pull"), (stack, world, entity, i) -> entity == null || CrossbowItem.isCharged((ItemStack)stack) ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / (float)CrossbowItem.getChargeDuration((ItemStack)stack, (LivingEntity)entity));
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)ResourceLocation.parse((String)"pulling"), (stack, world, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack && !CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)ResourceLocation.parse((String)"charged"), (stack, world, entity, i) -> entity != null && CrossbowItem.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)crossbowItem, (ResourceLocation)ResourceLocation.parse((String)"firework"), (stack, world, entity, seed) -> ((ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY)).contains(Items.FIREWORK_ROCKET) ? 1.0f : 0.0f);
    }

    private static void registerPipeBombPredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"armed"), (stack, world, entity, seed) -> PipeBombItem.isPrimed(stack) ? 1.0f : 0.0f);
    }

    private static void registerSpectrumFishingRodItemPredicates(Item fishingRodItem) {
        ItemProperties.register((Item)fishingRodItem, (ResourceLocation)ResourceLocation.parse((String)"cast"), (stack, world, entity, i) -> {
            if (entity == null) {
                return 0.0f;
            }
            boolean isInMainHand = entity.getMainHandItem() == stack;
            boolean isInOffhand = entity.getOffhandItem() == stack && !(entity.getMainHandItem().getItem() instanceof PastelFishingRodItem);
            return (isInMainHand || isInOffhand) && entity instanceof Player && ((PlayerEntityAccessor)entity).getSpectrumBobber() != null ? 1.0f : 0.0f;
        });
    }

    private static void registerEnderSplicePredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"bound"), (stack, world, entity, i) -> EnderSpliceItem.hasTeleportTarget(stack) ? 1.0f : 0.0f);
    }

    private static void registerAshenCircletPredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"cooldown"), (stack, world, entity, i) -> world != null && AshenCircletItem.getCooldownTicks(stack, (Level)world) == 0L ? 0.0f : 1.0f);
    }

    private static void registerAnimatedWandPredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"in_use"), (stack, world, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
    }

    private static void registerKnowledgeDropPredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"fill"), (stack, world, entity, i) -> {
            if (world == null) {
                return 0.0f;
            }
            ExperienceHandler storage = (ExperienceHandler)stack.getCapability(PastelCapabilities.Misc.XP, (Object)world.registryAccess());
            assert (storage != null);
            return (float)storage.getStoredAmount() / (float)Math.min(storage.getCapacity(), 1000000);
        });
    }

    private static void registerInkFillStateItemPredicate(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"fill_state"), (stack, world, entity, i) -> {
            SingleInkStorage storage = ((InkFlaskItem)PastelItems.INK_FLASK.get()).getEnergyStorage(stack);
            float current = storage.getCurrentTotal();
            float maximum = storage.getMaxTotal();
            if (current == 0.0f || maximum == 0.0f) {
                return 0.0f;
            }
            float fill = current / maximum;
            if (fill < 0.1f) {
                return 0.1f;
            }
            if (fill < 0.25f) {
                return 0.25f;
            }
            if (fill < 0.4f) {
                return 0.4f;
            }
            if (fill < 0.65f) {
                return 0.65f;
            }
            if (fill < 0.8f) {
                return 0.8f;
            }
            return 1.0f;
        });
    }

    private static void registerEnchantmentCanvasPredicates(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"bound"), (stack, world, entity, i) -> stack.has(PastelDataComponentTypes.BOUND_ITEM) ? 1.0f : 0.0f);
    }
}

