/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PastelRegistry<T>
extends MappedRegistry<T> {
    public PastelRegistry(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle) {
        super(key, lifecycle);
    }

    public Codec<T> byNameCodec() {
        return this.referenceHolderWithLifecycle().flatComapMap(Holder.Reference::value, value -> this.safeCastToReference(this.wrapAsHolder(value)));
    }

    public Codec<Holder<T>> holderByNameCodec() {
        return this.referenceHolderWithLifecycle().flatComapMap(entry -> entry, this::safeCastToReference);
    }

    protected Codec<Holder.Reference<T>> referenceHolderWithLifecycle() {
        return CodecHelper.SPECTRUM_DEFAULTED_IDENTIFIER.comapFlatMap(id -> this.getHolder((ResourceLocation)id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.key()) + ": " + String.valueOf(id))), entry -> entry.key().location());
    }

    protected DataResult<Holder.Reference<T>> safeCastToReference(Holder<T> entry) {
        DataResult dataResult;
        if (entry instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)entry;
            dataResult = DataResult.success((Object)reference);
        } else {
            dataResult = DataResult.error(() -> "Unregistered holder in " + String.valueOf(this.key()) + ": " + String.valueOf(entry));
        }
        return dataResult;
    }

    @Nullable
    public T get(@Nullable String id) {
        return (T)(id == null ? null : this.get(PastelCommon.ofPastel(id)));
    }
}

