/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.api.interaction.OmniAcceleratorProjectile;
import earth.terrarium.pastel.blocks.shooting_star.ShootingStarItem;
import earth.terrarium.pastel.entity.entity.ShootingStarEntity;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class PastelOmniAcceleratorProjectiles {
    public static void register() {
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                ThrownPotion potionEntity = new ThrownPotion(world, shooter);
                potionEntity.setItem(stack);
                potionEntity.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 1.0f);
                world.addFreshEntity((Entity)potionEntity);
                return potionEntity;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return SoundEvents.SPLASH_POTION_THROW;
            }
        }, new ItemLike[]{Items.SPLASH_POTION});
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                ThrownPotion potionEntity = new ThrownPotion(world, shooter);
                potionEntity.setItem(stack);
                potionEntity.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 1.0f);
                world.addFreshEntity((Entity)potionEntity);
                return potionEntity;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return SoundEvents.LINGERING_POTION_THROW;
            }
        }, new ItemLike[]{Items.LINGERING_POTION});
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                ThrownEnderpearl enderPearlEntity = new ThrownEnderpearl(world, shooter);
                enderPearlEntity.setItem(stack);
                enderPearlEntity.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 1.0f);
                world.addFreshEntity((Entity)enderPearlEntity);
                return enderPearlEntity;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return SoundEvents.ENDER_PEARL_THROW;
            }
        }, new ItemLike[]{Items.ENDER_PEARL});
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                Item item = stack.getItem();
                if (item instanceof ArrowItem) {
                    ArrowItem arrowItem = (ArrowItem)item;
                    AbstractArrow arrowEntity = arrowItem.createArrow(world, stack, shooter, shotFrom);
                    arrowEntity.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 1.0f);
                    world.addFreshEntity((Entity)arrowEntity);
                    return arrowEntity;
                }
                return null;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return SoundEvents.ARROW_SHOOT;
            }
        }, (TagKey<Item>)ItemTags.ARROWS);
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                Snowball snowballEntity = new Snowball(world, shooter);
                snowballEntity.setItem(stack);
                snowballEntity.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 1.0f);
                world.addFreshEntity((Entity)snowballEntity);
                return snowballEntity;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return SoundEvents.SNOWBALL_THROW;
            }
        }, new ItemLike[]{Items.SNOWBALL});
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                ThrownEgg eggEntity = new ThrownEgg(world, shooter);
                eggEntity.setItem(stack);
                eggEntity.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 1.0f);
                world.addFreshEntity((Entity)eggEntity);
                return eggEntity;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return SoundEvents.EGG_THROW;
            }
        }, new ItemLike[]{Items.EGG});
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                Vec3 pos = shooter.getEyePosition();
                PrimedTnt tntEntity = new PrimedTnt(world, pos.x() + 0.5, pos.y(), pos.z() + 0.5, shooter);
                OmniAcceleratorProjectile.setVelocity((Entity)tntEntity, (Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 1.0f);
                if (world.addFreshEntity((Entity)tntEntity)) {
                    world.gameEvent((Entity)shooter, (Holder)GameEvent.PRIME_FUSE, pos);
                    return tntEntity;
                }
                return null;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return SoundEvents.TNT_PRIMED;
            }
        }, new ItemLike[]{Items.TNT});
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity(world, stack, shooter);
                fireworkRocketEntity.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 0.0f);
                world.addFreshEntity((Entity)fireworkRocketEntity);
                return fireworkRocketEntity;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return SoundEvents.FIREWORK_ROCKET_LAUNCH;
            }
        }, new ItemLike[]{Items.FIREWORK_ROCKET});
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                ShootingStarEntity shootingStarEntity = ((ShootingStarItem)stack.getItem()).getEntityForStack(world, shooter.getEyePosition(), stack);
                OmniAcceleratorProjectile.setVelocity(shootingStarEntity, (Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 0.0f);
                world.addFreshEntity((Entity)shootingStarEntity);
                shootingStarEntity.noPhysics = true;
                shootingStarEntity.move(MoverType.SELF, shootingStarEntity.getDeltaMovement());
                shootingStarEntity.move(MoverType.SELF, shootingStarEntity.getDeltaMovement());
                shootingStarEntity.noPhysics = false;
                return shootingStarEntity;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return PastelSounds.SHOOTING_STAR_CRACKER;
            }
        }, PastelItemTags.SHOOTING_STARS);
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                Vec3 pos = shooter.getEyePosition();
                Item item = stack.getItem();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(world, pos.x() + 0.5, pos.y(), pos.z() + 0.5, blockItem.getBlock().defaultBlockState());
                    OmniAcceleratorProjectile.setVelocity((Entity)fallingBlockEntity, (Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 0.0f);
                    world.addFreshEntity((Entity)fallingBlockEntity);
                    world.addFreshEntity((Entity)fallingBlockEntity);
                    return fallingBlockEntity;
                }
                return null;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return SoundEvents.ANVIL_PLACE;
            }
        }, (TagKey<Item>)ItemTags.ANVIL);
        OmniAcceleratorProjectile.register(new OmniAcceleratorProjectile(){

            @Override
            public Entity createProjectile(ItemStack stack, LivingEntity shooter, Level world, ItemStack shotFrom) {
                if (shooter instanceof Player) {
                    Player player = (Player)shooter;
                    WindCharge windChargeEntity = new WindCharge(player, world, shooter.position().x(), shooter.getEyePosition().y(), shooter.position().z());
                    windChargeEntity.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 0.0f);
                    world.addFreshEntity((Entity)windChargeEntity);
                }
                return null;
            }

            @Override
            public SoundEvent getSoundEffect() {
                return SoundEvents.WIND_CHARGE_THROW;
            }
        }, new ItemLike[]{Items.WIND_CHARGE});
    }
}

