/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class PastelLoadConditions {
    public static void register(IEventBus modEventBus) {
        DeferredRegister register = DeferredRegister.create((Registry)NeoForgeRegistries.CONDITION_SERIALIZERS, (String)"pastel");
        register.register("tags_populated", () -> PastelTagsPopulatedResourceCondition.CODEC);
        register.register(modEventBus);
    }

    public record PastelTagsPopulatedResourceCondition(ResourceLocation registry, List<ResourceLocation> tags) implements ICondition
    {
        public static final MapCodec<PastelTagsPopulatedResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("registry").orElse((Object)Registries.ITEM.location()).forGetter(PastelTagsPopulatedResourceCondition::registry), (App)ResourceLocation.CODEC.listOf().fieldOf("values").forGetter(PastelTagsPopulatedResourceCondition::tags)).apply((Applicative)instance, PastelTagsPopulatedResourceCondition::new));

        public boolean test(ICondition.IContext context) {
            return PastelTagsPopulatedResourceCondition.tagsPopulated(context, this.registry(), this.tags());
        }

        public MapCodec<? extends ICondition> codec() {
            return CODEC;
        }

        public static boolean tagsPopulated(ICondition.IContext context, ResourceLocation registryId, List<ResourceLocation> tags) {
            ResourceKey registryKey = ResourceKey.createRegistryKey((ResourceLocation)registryId);
            for (ResourceLocation tag : tags) {
                TagKey tagKey = TagKey.create((ResourceKey)registryKey, (ResourceLocation)tag);
                Collection entries = context.getTag(tagKey);
                if (!entries.isEmpty()) continue;
                return false;
            }
            return true;
        }
    }
}

