/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.api.recipe.FusionShrineRecipeWorldEffect;
import earth.terrarium.pastel.blocks.fluid.MidnightSolutionFluidBlock;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithExactVelocityPayload;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelRegistryKeys;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PastelFusionShrineWorldEffects {
    public static final DeferredRegister<FusionShrineRecipeWorldEffect> REGISTER = DeferredRegister.create(PastelRegistryKeys.WORLD_EFFECT, (String)"pastel");
    public static FusionShrineRecipeWorldEffect WEATHER_CLEAR = FusionShrineRecipeWorldEffect.register("weather_clear", new FusionShrineRecipeWorldEffect.SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            ServerLevelData serverWorldProperties = (ServerLevelData)world.getLevelData();
            serverWorldProperties.setRainTime(0);
            serverWorldProperties.setRaining(false);
            serverWorldProperties.setThunderTime(0);
            serverWorldProperties.setThundering(false);
        }
    });
    public static FusionShrineRecipeWorldEffect WEATHER_RAIN = FusionShrineRecipeWorldEffect.register("weather_rain", new FusionShrineRecipeWorldEffect.SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            ServerLevelData serverWorldProperties = (ServerLevelData)world.getLevelData();
            serverWorldProperties.setRainTime(Mth.randomBetweenInclusive((RandomSource)world.random, (int)12000, (int)18000));
            serverWorldProperties.setRaining(true);
            serverWorldProperties.setThunderTime(0);
            serverWorldProperties.setThundering(false);
            world.playSound(null, pos.above(), SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.8f, 0.9f + world.random.nextFloat() * 0.2f);
        }
    });
    public static FusionShrineRecipeWorldEffect WEATHER_THUNDER = FusionShrineRecipeWorldEffect.register("weather_thunder", new FusionShrineRecipeWorldEffect.SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            ServerLevelData serverWorldProperties = (ServerLevelData)world.getLevelData();
            serverWorldProperties.setRainTime(Mth.randomBetweenInclusive((RandomSource)world.random, (int)12000, (int)24000));
            serverWorldProperties.setRaining(true);
            serverWorldProperties.setThunderTime(Mth.randomBetweenInclusive((RandomSource)world.random, (int)3600, (int)15600));
            serverWorldProperties.setThundering(true);
            world.playSound(null, pos.above(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 0.8f, 0.9f + world.random.nextFloat() * 0.2f);
        }
    });
    public static FusionShrineRecipeWorldEffect WEATHER_RAIN_SHORT = FusionShrineRecipeWorldEffect.register("weather_rain_short", new FusionShrineRecipeWorldEffect.SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            ServerLevelData serverWorldProperties = (ServerLevelData)world.getLevelData();
            serverWorldProperties.setRainTime(Mth.randomBetweenInclusive((RandomSource)world.random, (int)4000, (int)6000));
            serverWorldProperties.setRaining(true);
            serverWorldProperties.setThunderTime(0);
            serverWorldProperties.setThundering(false);
            world.playSound(null, pos.above(), SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.8f, 0.9f + world.random.nextFloat() * 0.2f);
        }
    });
    public static FusionShrineRecipeWorldEffect WEATHER_THUNDER_SHORT = FusionShrineRecipeWorldEffect.register("weather_thunder_short", new FusionShrineRecipeWorldEffect.SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            ServerLevelData serverWorldProperties = (ServerLevelData)world.getLevelData();
            serverWorldProperties.setRainTime(Mth.randomBetweenInclusive((RandomSource)world.random, (int)4000, (int)6000));
            serverWorldProperties.setRaining(true);
            serverWorldProperties.setThunderTime(Mth.randomBetweenInclusive((RandomSource)world.random, (int)3000, (int)4000));
            serverWorldProperties.setThundering(true);
            world.playSound(null, pos.above(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 0.8f, 0.9f + world.random.nextFloat() * 0.2f);
        }
    });
    public static FusionShrineRecipeWorldEffect LIGHTNING_ON_SHRINE = FusionShrineRecipeWorldEffect.register("lightning_on_shrine", new FusionShrineRecipeWorldEffect.SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            LightningBolt lightningEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)world);
            if (lightningEntity != null) {
                lightningEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                lightningEntity.setVisualOnly(true);
                world.addFreshEntity((Entity)lightningEntity);
            }
        }
    });
    public static FusionShrineRecipeWorldEffect LIGHTNING_AROUND_SHRINE = FusionShrineRecipeWorldEffect.register("lightning_around_shrine", new FusionShrineRecipeWorldEffect.EveryTickRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            if (world.getRandom().nextFloat() < 0.05f) {
                int randomX = pos.getX() + 12 - world.getRandom().nextInt(24);
                int randomZ = pos.getZ() + 12 - world.getRandom().nextInt(24);
                BlockPos randomTopPos = new BlockPos(randomX, world.getHeight(Heightmap.Types.WORLD_SURFACE, randomX, randomZ), randomZ);
                LightningBolt lightningEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)world);
                if (lightningEntity != null) {
                    lightningEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)randomTopPos));
                    lightningEntity.setVisualOnly(false);
                    world.addFreshEntity((Entity)lightningEntity);
                }
            }
        }
    });
    public static FusionShrineRecipeWorldEffect VISUAL_EXPLOSIONS_ON_SHRINE = FusionShrineRecipeWorldEffect.register("visual_explosions_on_shrine", new FusionShrineRecipeWorldEffect.EveryTickRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            if ((double)world.getRandom().nextFloat() < 0.1) {
                world.playSound(null, pos.above(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 0.5f, 0.8f + world.random.nextFloat() * 0.4f);
                PlayParticleWithExactVelocityPayload.playParticles(world, pos.above(), (ParticleOptions)ParticleTypes.EXPLOSION, 1);
            }
        }
    });
    public static FusionShrineRecipeWorldEffect SINGLE_VISUAL_EXPLOSION_ON_SHRINE = FusionShrineRecipeWorldEffect.register("single_visual_explosion_on_shrine", new FusionShrineRecipeWorldEffect.SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            world.playSound(null, pos.above(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 0.8f, 0.8f + world.random.nextFloat() * 0.4f);
            PlayParticleWithExactVelocityPayload.playParticles(world, pos, (ParticleOptions)ParticleTypes.EXPLOSION, 1);
        }
    });
    public static FusionShrineRecipeWorldEffect MAYBE_PLACE_MIDNIGHT_SOLUTION = FusionShrineRecipeWorldEffect.register("maybe_place_midnight_solution", new FusionShrineRecipeWorldEffect.EveryTickRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            Optional<BlockPos> targetPos;
            if (world.getRandom().nextFloat() < 0.05f && (targetPos = Support.getNexReplaceableBlockPosUpDown((Level)world, pos.offset(5 - world.getRandom().nextInt(10), 1, 5 - world.getRandom().nextInt(10)), 5)).isPresent()) {
                BlockPos p = targetPos.get();
                if (p.getX() == pos.getX() && p.getZ() == pos.getZ()) {
                    return;
                }
                world.setBlockAndUpdate(targetPos.get(), ((Block)PastelBlocks.MIDNIGHT_SOLUTION.get()).defaultBlockState());
                MidnightSolutionFluidBlock.fizz((LevelAccessor)world, targetPos.get());
            }
        }
    });
    public static FusionShrineRecipeWorldEffect PLACE_MIDNIGHT_SOLUTION = FusionShrineRecipeWorldEffect.register("place_midnight_solution", new FusionShrineRecipeWorldEffect.EveryTickRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            Optional<BlockPos> targetPos = Support.getNexReplaceableBlockPosUpDown((Level)world, pos.offset(5 - world.getRandom().nextInt(10), 1, 5 - world.getRandom().nextInt(10)), 5);
            if (targetPos.isPresent()) {
                BlockPos p = targetPos.get();
                if (p.getX() == pos.getX() && p.getZ() == pos.getZ()) {
                    return;
                }
                world.setBlockAndUpdate(p, ((Block)PastelBlocks.MIDNIGHT_SOLUTION.get()).defaultBlockState());
                MidnightSolutionFluidBlock.fizz((LevelAccessor)world, targetPos.get());
            }
        }
    });
    public static FusionShrineRecipeWorldEffect EXPLOSIONS_AROUND_SHRINE = FusionShrineRecipeWorldEffect.register("explosions_around_shrine", new FusionShrineRecipeWorldEffect.EveryTickRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            if ((double)world.getRandom().nextFloat() < 0.1) {
                float randomX = (float)pos.getX() + 0.5f + 10.0f - (float)world.getRandom().nextInt(20);
                float randomY = (float)pos.getY() + 0.5f + 1.0f - (float)world.getRandom().nextInt(3);
                float randomZ = (float)pos.getZ() + 0.5f + 10.0f - (float)world.getRandom().nextInt(20);
                world.explode(null, (double)randomX, (double)randomY, (double)randomZ, 4.0f, Level.ExplosionInteraction.NONE);
            }
        }
    });
    public static FusionShrineRecipeWorldEffect EXPLOSIONS_AND_LIGHTNING_AROUND_SHRINE = FusionShrineRecipeWorldEffect.register("explosions_and_lightning_around_shrine", new FusionShrineRecipeWorldEffect.EveryTickRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            if ((double)world.getRandom().nextFloat() < 0.1) {
                float randomX = (float)pos.getX() + 0.5f + 10.0f - (float)world.getRandom().nextInt(20);
                float randomY = (float)pos.getY() + 0.5f + 1.0f - (float)world.getRandom().nextInt(3);
                float randomZ = (float)pos.getZ() + 0.5f + 10.0f - (float)world.getRandom().nextInt(20);
                world.explode(null, (double)randomX, (double)randomY, (double)randomZ, 4.0f, Level.ExplosionInteraction.NONE);
            }
            if (world.getRandom().nextFloat() < 0.05f) {
                int randomX = pos.getX() + 12 - world.getRandom().nextInt(24);
                int randomZ = pos.getZ() + 12 - world.getRandom().nextInt(24);
                BlockPos randomTopPos = new BlockPos(randomX, world.getHeight(Heightmap.Types.WORLD_SURFACE, randomX, randomZ), randomZ);
                LightningBolt lightningEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)world);
                if (lightningEntity != null) {
                    lightningEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)randomTopPos));
                    lightningEntity.setVisualOnly(false);
                    world.addFreshEntity((Entity)lightningEntity);
                }
            }
        }
    });
    public static FusionShrineRecipeWorldEffect PLAY_GLASS_BREAKING_SOUND = FusionShrineRecipeWorldEffect.register("play_glass_breaking_sound", new FusionShrineRecipeWorldEffect.SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            world.playSound(null, pos.above(), SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    });
    public static FusionShrineRecipeWorldEffect LEGENDARY_TOOL_CRAFT = FusionShrineRecipeWorldEffect.register("legendary_tool_craft", new FusionShrineRecipeWorldEffect.SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            world.playSound(null, pos.above(), PastelSounds.LEGENDARY_WEAPON_CRAFT, SoundSource.BLOCKS, 1.5f, 1.0f);
        }
    });
    public static FusionShrineRecipeWorldEffect RIDICULOUSLY_SQUEAKY_FART = FusionShrineRecipeWorldEffect.register("ridiculously_squeaky_fart", new FusionShrineRecipeWorldEffect.SingleTimeRecipeWorldEffect(){

        @Override
        public void trigger(ServerLevel world, BlockPos pos) {
            world.playSound(null, pos.above(), PastelSounds.SQUEAKER, SoundSource.BLOCKS, 1.4f, 1.2f + world.random.nextFloat() * 0.4f);
        }
    });

    public static void register(IEventBus bus) {
        REGISTER.register(bus);
    }
}

