/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.color.ItemColors;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.blocks.fluid.DragonrotFluid;
import earth.terrarium.pastel.blocks.fluid.HumusFluid;
import earth.terrarium.pastel.blocks.fluid.LiquidCrystalFluid;
import earth.terrarium.pastel.blocks.fluid.MidnightSolutionFluid;
import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.render.FluidRendering;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class PastelFluids {
    private static final DeferredRegister<Fluid> FLUID_REGISTER = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"pastel");
    private static final DeferredRegister<FluidType> TYPE_REGISTER = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"pastel");
    public static final DeferredHolder<FluidType, FluidType> LIQUID_CRYSTAL_TYPE = TYPE_REGISTER.register("liquid_crystal", () -> new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<Fluid, PastelFluid> LIQUID_CRYSTAL = FLUID_REGISTER.register("liquid_crystal", LiquidCrystalFluid.Still::new);
    public static final DeferredHolder<Fluid, PastelFluid> FLOWING_LIQUID_CRYSTAL = FLUID_REGISTER.register("flowing_liquid_crystal", LiquidCrystalFluid.Flowing::new);
    public static final int LIQUID_CRYSTAL_TINT = -3425333;
    public static final Vector3f LIQUID_CRYSTAL_COLOR_VEC = ColorHelper.colorIntToVec(-3425333);
    public static final float LIQUID_CRYSTAL_OVERLAY_ALPHA = 0.6f;
    public static final DeferredHolder<FluidType, FluidType> HUMUS_TYPE = TYPE_REGISTER.register("humus", () -> new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<Fluid, PastelFluid> HUMUS = FLUID_REGISTER.register("humus", HumusFluid.StillHumus::new);
    public static final DeferredHolder<Fluid, PastelFluid> FLOWING_HUMUS = FLUID_REGISTER.register("flowing_humus", HumusFluid.FlowingHumus::new);
    public static final int HUMUS_TINT = -11653622;
    public static final Vector3f HUMUS_COLOR_VEC = ColorHelper.colorIntToVec(-11653622);
    public static final float HUMUS_OVERLAY_ALPHA = 0.995f;
    public static final DeferredHolder<FluidType, FluidType> MIDNIGHT_SOLUTION_TYPE = TYPE_REGISTER.register("midnight_solution", () -> new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<Fluid, PastelFluid> MIDNIGHT_SOLUTION = FLUID_REGISTER.register("midnight_solution", MidnightSolutionFluid.Still::new);
    public static final DeferredHolder<Fluid, PastelFluid> FLOWING_MIDNIGHT_SOLUTION = FLUID_REGISTER.register("flowing_midnight_solution", MidnightSolutionFluid.Flowing::new);
    public static final int MIDNIGHT_SOLUTION_TINT = -15656901;
    public static final Vector3f MIDNIGHT_SOLUTION_COLOR_VEC = ColorHelper.colorIntToVec(-15656901);
    public static final float MIDNIGHT_SOLUTION_OVERLAY_ALPHA = 0.995f;
    public static final DeferredHolder<FluidType, FluidType> DRAGONROT_TYPE = TYPE_REGISTER.register("dragonrot", () -> new FluidType(FluidType.Properties.create()));
    public static final DeferredHolder<Fluid, PastelFluid> DRAGONROT = FLUID_REGISTER.register("dragonrot", DragonrotFluid.Still::new);
    public static final DeferredHolder<Fluid, PastelFluid> FLOWING_DRAGONROT = FLUID_REGISTER.register("flowing_dragonrot", DragonrotFluid.Flowing::new);
    public static final int DRAGONROT_TINT = -1870033;
    public static final Vector3f DRAGONROT_COLOR_VEC = ColorHelper.colorIntToVec(-1870033);
    public static final float DRAGONROT_OVERLAY_ALPHA = 0.98f;

    public static void register(IEventBus bus) {
        FLUID_REGISTER.register(bus);
        TYPE_REGISTER.register(bus);
    }

    private static void registerFluid(String name, Fluid stillFluid, Fluid flowingFluid, InkColor color) {
        FLUID_REGISTER.register(name, () -> stillFluid);
        FLUID_REGISTER.register("flowing_" + name, () -> flowingFluid);
        ItemColors.FLUID_COLORS.registerColorMapping(stillFluid, color);
        ItemColors.FLUID_COLORS.registerColorMapping(flowingFluid, color);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        List<PastelFluid> fluids = List.of((PastelFluid)((Object)LIQUID_CRYSTAL.get()), (PastelFluid)((Object)FLOWING_LIQUID_CRYSTAL.get()), (PastelFluid)((Object)HUMUS.get()), (PastelFluid)((Object)FLOWING_HUMUS.get()), (PastelFluid)((Object)MIDNIGHT_SOLUTION.get()), (PastelFluid)((Object)FLOWING_MIDNIGHT_SOLUTION.get()), (PastelFluid)((Object)DRAGONROT.get()), (PastelFluid)((Object)FLOWING_DRAGONROT.get()));
        for (PastelFluid fluid : fluids) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)RenderType.translucent());
        }
    }

    public static void registerClient(RegisterClientExtensionsEvent event) {
        PastelFluids.setupFluidRendering(event, (FluidType)LIQUID_CRYSTAL_TYPE.get(), "liquid_crystal", -3425333, 0.6f);
        PastelFluids.setupFluidRendering(event, (FluidType)HUMUS_TYPE.get(), "humus", -11653622, 0.995f);
        PastelFluids.setupFluidRendering(event, (FluidType)MIDNIGHT_SOLUTION_TYPE.get(), "midnight_solution", -15656901, 0.995f);
        PastelFluids.setupFluidRendering(event, (FluidType)DRAGONROT_TYPE.get(), "dragonrot", -1870033, 0.98f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void setupFluidRendering(RegisterClientExtensionsEvent event, FluidType fluidType, String name, final int tint, final float overlayAlpha) {
        final ResourceLocation overlay = PastelCommon.locate("textures/misc/%s_overlay.png".formatted(name));
        final ResourceLocation still = PastelCommon.locate("block/%s_still".formatted(name));
        final ResourceLocation flowing = PastelCommon.locate("block/%s_flow".formatted(name));
        event.registerFluidType(new IClientFluidTypeExtensions(){

            @NotNull
            public ResourceLocation getStillTexture() {
                return still;
            }

            @NotNull
            public ResourceLocation getFlowingTexture() {
                return flowing;
            }

            public void renderOverlay(@NotNull Minecraft mc, @NotNull PoseStack stack) {
                FluidRendering.renderFluidOverlay(mc, stack, overlay, overlayAlpha);
            }

            public int getTintColor() {
                return tint;
            }
        }, new FluidType[]{fluidType});
    }
}

