/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.titration_barrel.dynamic;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.components.BeverageComponent;
import earth.terrarium.pastel.components.JadeWineComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.interaction.TimeHelper;
import earth.terrarium.pastel.recipe.titration_barrel.FermentationData;
import earth.terrarium.pastel.recipe.titration_barrel.TitrationBarrelRecipe;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public abstract class SweetenableTitrationBarrelRecipe
extends TitrationBarrelRecipe {
    public SweetenableTitrationBarrelRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, List<IngredientStack> inputStacks, FluidIngredient fluid, ItemStack outputItemStack, Item tappingItem, int minFermentationTimeHours, FermentationData fermentationData) {
        super(group, secret, requiredAdvancementIdentifier, inputStacks, fluid, outputItemStack, tappingItem, minFermentationTimeHours, fermentationData);
    }

    @Override
    public ItemStack getPreviewTap(int timeMultiplier) {
        return this.tapWith(1, 3, false, 1.0f, (long)this.minFermentationTimeHours * 60L * 60L * (long)timeMultiplier, 0.4f);
    }

    protected abstract List<MobEffectInstance> getEffects(boolean var1, double var2, double var4);

    protected ItemStack tapWith(int bulbCount, int petalCount, boolean nectar, float thickness, long secondsFermented, float downfall) {
        double alcPercent;
        double bloominess = SweetenableTitrationBarrelRecipe.getBloominess(bulbCount, petalCount);
        float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
        if (nectar) {
            thickness *= 1.5f;
        }
        if ((alcPercent = this.getAlcPercentWithBloominess(ageIngameDays, downfall, bloominess, thickness)) >= 100.0) {
            return ((Item)PastelItems.CHRYSOCOLLA.get()).getDefaultInstance();
        }
        List<MobEffectInstance> effects = this.getEffects(nectar, bloominess, alcPercent);
        ItemStack outputStack = this.outputItemStack.copy();
        outputStack.setCount(1);
        outputStack.set(PastelDataComponentTypes.BEVERAGE, (Object)new BeverageComponent((long)ageIngameDays, (int)alcPercent, thickness));
        outputStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), effects));
        outputStack.set(PastelDataComponentTypes.JADE_WINE, (Object)new JadeWineComponent((float)bloominess, nectar));
        return outputStack;
    }

    protected static double getBloominess(int bulbCount, int petalCount) {
        if (bulbCount == 0) {
            return 0.0;
        }
        return (double)petalCount / (double)bulbCount / 2.0;
    }

    protected float getThickness(int bulbCount, int petalCount) {
        return (float)bulbCount + (float)petalCount / 8.0f;
    }

    protected double getAlcPercentWithBloominess(float ageIngameDays, float downfall, double bloominess, double thickness) {
        return Support.logBase((double)(1.0f + this.fermentationData.fermentationSpeedMod()) + bloominess / 64.0, (double)ageIngameDays * (0.5 + thickness / 2.0) * (0.5 + (double)downfall / 2.0));
    }
}

