/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.titration_barrel.dynamic;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.recipe.FluidRecipeInput;
import earth.terrarium.pastel.recipe.titration_barrel.FermentationData;
import earth.terrarium.pastel.recipe.titration_barrel.dynamic.SweetenableTitrationBarrelRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class NecteredViognierRecipe
extends SweetenableTitrationBarrelRecipe {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("hidden/collect_cookbooks/imperial_cookbook");
    public static final int MIN_FERMENTATION_TIME_HOURS = 24;
    public static final ItemStack OUTPUT_STACK = NecteredViognierRecipe.getDefaultStackWithCount((Item)PastelItems.NECTERED_VIOGNIER.get(), 4);
    public static final Item TAPPING_ITEM = Items.GLASS_BOTTLE;
    public static final List<IngredientStack> INGREDIENT_STACKS = new ArrayList<IngredientStack>(){
        {
            this.add(IngredientStack.ofItems(((Block)PastelBlocks.NEPHRITE_BLOSSOM_BULB.get()).asItem()));
            this.add(IngredientStack.ofItems((Item)PastelItems.GLASS_PEACH.get(), 4));
        }
    };

    public NecteredViognierRecipe() {
        super("", false, Optional.of(UNLOCK_IDENTIFIER), INGREDIENT_STACKS, FluidIngredient.of((Fluid[])new Fluid[]{Fluids.WATER}), OUTPUT_STACK, TAPPING_ITEM, 24, new FermentationData(0.15f, 0.01f, List.of()));
    }

    @Override
    public ItemStack tap(FriendlyStackHandler inventory, long secondsFermented, float downfall) {
        int bulbCount = InventoryHelper.getItemCountInInventory((IItemHandler)inventory, ((Block)PastelBlocks.NEPHRITE_BLOSSOM_BULB.get()).asItem());
        int petalCount = InventoryHelper.getItemCountInInventory((IItemHandler)inventory, (Item)PastelItems.GLASS_PEACH.get());
        boolean nectar = InventoryHelper.getItemCountInInventory((IItemHandler)inventory, (Item)PastelItems.MOONSTRUCK_NECTAR.get()) > 0;
        float thickness = this.getThickness(bulbCount, petalCount);
        return this.tapWith(bulbCount, petalCount, nectar, thickness, secondsFermented, downfall);
    }

    @Override
    @NotNull
    protected List<MobEffectInstance> getEffects(boolean nectar, double bloominess, double alcPercent) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        int effectDuration = (int)(150L * Math.round(alcPercent / 10.0));
        if (alcPercent >= 35.0) {
            effects.add(new MobEffectInstance(PastelMobEffects.MAGIC_ANNULATION, effectDuration, (int)(alcPercent / 10.0)));
        }
        if (alcPercent >= 35.0) {
            effects.add(new MobEffectInstance(PastelMobEffects.TOUGHNESS, effectDuration, (int)(alcPercent / 10.0)));
            effectDuration = (int)((double)effectDuration * 1.5);
        }
        if (alcPercent >= 30.0) {
            effects.add(new MobEffectInstance(MobEffects.DAMAGE_BOOST, effectDuration, (int)(alcPercent / 10.0)));
            effectDuration = (int)((double)effectDuration * 1.5);
        }
        if (alcPercent >= 20.0) {
            effects.add(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, effectDuration, (int)(alcPercent / 45.0)));
            effectDuration = (int)((double)effectDuration * 1.5);
        }
        if (alcPercent >= 10.0) {
            effects.add(new MobEffectInstance(PastelMobEffects.NOURISHING, effectDuration));
            effectDuration = (int)((double)effectDuration * 1.5);
        }
        if (nectar) {
            effects.add(new MobEffectInstance(PastelMobEffects.IMMUNITY, effectDuration / 2));
        }
        int nectarMod = nectar ? 3 : 1;
        effectDuration = 1200;
        int alcAfterBloominess = (int)(alcPercent / ((double)nectarMod + bloominess));
        if (alcAfterBloominess >= 40) {
            effects.add(new MobEffectInstance(MobEffects.BLINDNESS, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 30) {
            effects.add(new MobEffectInstance(MobEffects.POISON, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 20) {
            effects.add(new MobEffectInstance(MobEffects.CONFUSION, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 10) {
            effects.add(new MobEffectInstance(MobEffects.WEAKNESS, effectDuration));
        }
        return effects;
    }

    @Override
    public boolean matches(FluidRecipeInput<FluidTank> recipeInput, Level world) {
        boolean bulbsFound = false;
        for (int i = 0; i < recipeInput.size(); ++i) {
            ItemStack stack = recipeInput.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(((Block)PastelBlocks.NEPHRITE_BLOSSOM_BULB.get()).asItem())) {
                bulbsFound = true;
                continue;
            }
            if (stack.is((Item)PastelItems.GLASS_PEACH.get()) || stack.is((Item)PastelItems.MOONSTRUCK_NECTAR.get())) continue;
            return false;
        }
        return bulbsFound;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.TITRATION_BARREL_NECTERED_VIOGNIER;
    }
}

