/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.titration_barrel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;

public record FermentationStatusEffectEntry(MobEffect statusEffect, int baseDuration, List<StatusEffectPotencyEntry> potencyEntries) {
    public static final Codec<FermentationStatusEffectEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)BuiltInRegistries.MOB_EFFECT.byNameCodec().orElse(err -> {
        PastelCommon.logError(err + ". Falling back to WEAKNESS");
        return err;
    }, (Object)((MobEffect)MobEffects.WEAKNESS.value())).fieldOf("id").forGetter(FermentationStatusEffectEntry::statusEffect), (App)Codec.INT.optionalFieldOf("base_duration", (Object)1200).forGetter(FermentationStatusEffectEntry::baseDuration), (App)StatusEffectPotencyEntry.CODEC.listOf().optionalFieldOf("potency", List.of(new StatusEffectPotencyEntry(0.0f, 0.0f, 0))).forGetter(FermentationStatusEffectEntry::potencyEntries)).apply((Applicative)i, FermentationStatusEffectEntry::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FermentationStatusEffectEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.MOB_EFFECT), FermentationStatusEffectEntry::statusEffect, (StreamCodec)ByteBufCodecs.VAR_INT, FermentationStatusEffectEntry::baseDuration, (StreamCodec)StatusEffectPotencyEntry.STREAM_CODEC.apply(ByteBufCodecs.list()), FermentationStatusEffectEntry::potencyEntries, FermentationStatusEffectEntry::new);

    public record StatusEffectPotencyEntry(float minAlcPercent, float minThickness, int potency) {
        public static final Codec<StatusEffectPotencyEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.optionalFieldOf("min_alc", (Object)Float.valueOf(0.0f)).forGetter(StatusEffectPotencyEntry::minAlcPercent), (App)Codec.FLOAT.optionalFieldOf("min_thickness", (Object)Float.valueOf(0.0f)).forGetter(StatusEffectPotencyEntry::minThickness), (App)Codec.INT.optionalFieldOf("potency", (Object)0).forGetter(StatusEffectPotencyEntry::potency)).apply((Applicative)i, StatusEffectPotencyEntry::new));
        public static final StreamCodec<ByteBuf, StatusEffectPotencyEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, StatusEffectPotencyEntry::minAlcPercent, (StreamCodec)ByteBufCodecs.FLOAT, StatusEffectPotencyEntry::minThickness, (StreamCodec)ByteBufCodecs.VAR_INT, StatusEffectPotencyEntry::potency, StatusEffectPotencyEntry::new);
    }
}

