/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.primordial_fire_burning;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.entity.FireproofItemEntity;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PrimordialFireBurningRecipe
extends GatedPastelRecipe<RecipeInput> {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("lategame/collect_doombloom_seed");
    protected final Ingredient input;
    protected final ItemStack output;

    public PrimordialFireBurningRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, Ingredient input, ItemStack output) {
        super(group, secret, requiredAdvancementIdentifier);
        this.input = input;
        this.output = output;
        this.registerInToastManager(this.getType(), this);
    }

    public boolean matches(RecipeInput inv, Level world) {
        return this.input.test(inv.getItem(0));
    }

    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider drm) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.output;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PastelBlocks.DOOMBLOOM.get());
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return UNLOCK_IDENTIFIER;
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.PRIMORDIAL_FIRE_BURNING_RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.PRIMORDIAL_FIRE_BURNING;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)this.input);
        return defaultedList;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "primordial_fire_burning";
    }

    public static PrimordialFireBurningRecipe getRecipeFor(@NotNull Level world, ItemStack stack) {
        return world.getRecipeManager().getRecipeFor(PastelRecipeTypes.PRIMORDIAL_FIRE_BURNING, (RecipeInput)new SingleRecipeInput(stack), world).map(RecipeHolder::value).orElse(null);
    }

    public static boolean processBlock(Level world, BlockPos pos, BlockState state) {
        Item item = state.getBlock().asItem();
        if (item == Items.AIR) {
            return false;
        }
        PrimordialFireBurningRecipe recipe = PrimordialFireBurningRecipe.getRecipeFor(world, item.getDefaultInstance());
        if (recipe == null) {
            return false;
        }
        ItemStack output = recipe.assemble((RecipeInput)new SingleRecipeInput(state.getBlock().asItem().getDefaultInstance()), (HolderLookup.Provider)world.registryAccess());
        world.playSound(null, pos, PastelSounds.PRIMORDIAL_FIRE_CRACKLE, SoundSource.BLOCKS, 0.7f, 1.0f);
        Item item2 = output.getItem();
        if (item2 instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item2;
            world.setBlockAndUpdate(pos, blockItem.getBlock().defaultBlockState());
        } else {
            world.removeBlock(pos, false);
            FireproofItemEntity.scatter(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, output);
        }
        return true;
    }

    public static boolean processItemEntity(Level world, ItemEntity itemEntity) {
        Vec3 pos = itemEntity.position();
        ItemStack inputStack = itemEntity.getItem();
        PrimordialFireBurningRecipe recipe = PrimordialFireBurningRecipe.getRecipeFor(world, inputStack);
        if (recipe == null) {
            return false;
        }
        int inputCount = inputStack.getCount();
        ItemStack outputStack = recipe.assemble((RecipeInput)new SingleRecipeInput(inputStack), (HolderLookup.Provider)world.registryAccess()).copy();
        outputStack.setCount(outputStack.getCount() * inputCount);
        inputStack.setCount(0);
        itemEntity.discard();
        FireproofItemEntity.scatter(world, pos.x(), pos.y(), pos.z(), outputStack);
        world.playSound(null, itemEntity.blockPosition(), PastelSounds.PRIMORDIAL_FIRE_CRACKLE, SoundSource.BLOCKS, 0.7f, 1.0f);
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<PrimordialFireBurningRecipe> {
        public static final MapCodec<PrimordialFireBurningRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)i, PrimordialFireBurningRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, PrimordialFireBurningRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, c -> c.group, (StreamCodec)ByteBufCodecs.BOOL, c -> c.secret, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), c -> c.requiredAdvancementIdentifier, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.input, (StreamCodec)ItemStack.STREAM_CODEC, c -> c.output, PrimordialFireBurningRecipe::new);

        public MapCodec<PrimordialFireBurningRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PrimordialFireBurningRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

