/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.pedestal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.item.GemstoneColor;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntity;
import earth.terrarium.pastel.blocks.pedestal.PedestalRecipeInput;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.recipe.pedestal.RawShapedPedestalRecipe;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ShapedPedestalRecipe
extends PedestalRecipe {
    protected final int width;
    protected final int height;
    protected final RawShapedPedestalRecipe rawShapedRecipe;

    public ShapedPedestalRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, PedestalTier tier, RawShapedPedestalRecipe rawShapedRecipe, Map<GemstoneColor, Integer> gemstonePowderInputs, ItemStack output, float experience, int craftingTime, boolean skipRecipeRemainders, boolean noBenefitsFromYieldUpgrades) {
        super(group, secret, requiredAdvancementIdentifier, tier, (List<IngredientStack>)rawShapedRecipe.getIngredients(), gemstonePowderInputs, output, experience, craftingTime, skipRecipeRemainders, noBenefitsFromYieldUpgrades);
        this.rawShapedRecipe = rawShapedRecipe;
        this.width = rawShapedRecipe.getWidth();
        this.height = rawShapedRecipe.getHeight();
    }

    @Override
    public boolean matches(PedestalRecipeInput inv, Level world) {
        return this.rawShapedRecipe.matches(inv.getCraftingGridInput()) && super.matches(inv, world);
    }

    @Override
    public void consumeIngredients(PedestalBlockEntity pedestal, PedestalRecipeInput input) {
        super.consumeIngredients(pedestal, input);
        boolean mirrored = this.rawShapedRecipe.matches(input.getCraftingGridInput(), true);
        FriendlyStackHandler inv = pedestal.getInventory();
        CraftingInput.Positioned positioned = CraftingInput.ofPositioned((int)3, (int)3, inv.getInternalList());
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int ingredientStackId = (mirrored ? this.width - 1 - x : x) + this.width * y;
                int slot = x + positioned.left() + 3 * (y + positioned.top());
                IngredientStack ingredient = (IngredientStack)this.inputs.get(ingredientStackId);
                ItemStack stack = inv.getStackInSlot(slot);
                if (stack.isEmpty()) continue;
                this.decrementGridSlot(pedestal, slot, ingredient.getCount(), stack);
            }
        }
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.SHAPED_PEDESTAL_RECIPE_SERIALIZER;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isShapeless() {
        return false;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedPedestalRecipe> {
        public static final MapCodec<ShapedPedestalRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)PedestalTier.CODEC.optionalFieldOf("tier", (Object)PedestalTier.BASIC).forGetter(recipe -> recipe.tier), (App)RawShapedPedestalRecipe.CODEC.forGetter(recipe -> recipe.rawShapedRecipe), (App)CodecHelper.registryMap(PastelRegistries.GEMSTONE_COLOR, Codec.INT).fieldOf("colors").forGetter(recipe -> recipe.powderInputs), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(recipe -> recipe.craftingTime), (App)Codec.BOOL.optionalFieldOf("skip_recipe_remainders", (Object)false).forGetter(recipe -> recipe.skipRecipeRemainders), (App)Codec.BOOL.optionalFieldOf("disable_yield_upgrades", (Object)false).forGetter(recipe -> recipe.noBenefitsFromYieldUpgrades)).apply((Applicative)i, ShapedPedestalRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapedPedestalRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, ByteBufCodecs.BOOL, recipe -> recipe.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), recipe -> recipe.requiredAdvancementIdentifier, PedestalTier.STREAM_CODEC, recipe -> recipe.tier, RawShapedPedestalRecipe.STREAM_CODEC, recipe -> recipe.rawShapedRecipe, ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.registry((ResourceKey)PastelRegistries.GEMSTONE_COLOR.key()), (StreamCodec)ByteBufCodecs.VAR_INT), recipe -> recipe.powderInputs, ItemStack.STREAM_CODEC, recipe -> recipe.output, ByteBufCodecs.FLOAT, recipe -> Float.valueOf(recipe.experience), ByteBufCodecs.VAR_INT, recipe -> recipe.craftingTime, ByteBufCodecs.BOOL, recipe -> recipe.skipRecipeRemainders, ByteBufCodecs.BOOL, recipe -> recipe.noBenefitsFromYieldUpgrades, ShapedPedestalRecipe::new);

        public MapCodec<ShapedPedestalRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedPedestalRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

