/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.pedestal;

import com.cmdpro.databank.DatabankUtils;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.mojang.serialization.Codec;
import earth.terrarium.pastel.api.item.GemstoneColor;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntity;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.pedestal.PastelGemstoneColor;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelMultiblocks;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PedestalTier implements StringRepresentable
{
    BASIC(PastelAdvancements.PLACE_PEDESTAL, null, new GemstoneColor[]{PastelGemstoneColor.CYAN, PastelGemstoneColor.MAGENTA, PastelGemstoneColor.YELLOW}),
    SIMPLE(PastelAdvancements.BUILD_BASIC_PEDESTAL_STRUCTURE, PastelMultiblocks.PEDESTAL_SIMPLE, new GemstoneColor[]{PastelGemstoneColor.CYAN, PastelGemstoneColor.MAGENTA, PastelGemstoneColor.YELLOW}),
    ADVANCED(PastelAdvancements.Midgame.BUILD_ADVANCED_PEDESTAL_STRUCTURE, PastelMultiblocks.PEDESTAL_ADVANCED, new GemstoneColor[]{PastelGemstoneColor.CYAN, PastelGemstoneColor.MAGENTA, PastelGemstoneColor.YELLOW, PastelGemstoneColor.BLACK}),
    COMPLEX(PastelAdvancements.Lategame.BUILD_COMPLEX_PEDESTAL_STRUCTURE, PastelMultiblocks.PEDESTAL_COMPLEX, PastelGemstoneColor.values());

    public final ResourceLocation unlockAdvancementId;
    @Nullable
    public final ResourceLocation structure;
    private final GemstoneColor[] gemstoneColors;
    public static final Codec<PedestalTier> CODEC;
    public static final StreamCodec<ByteBuf, PedestalTier> STREAM_CODEC;

    private PedestalTier(ResourceLocation unlockAdvancementId, ResourceLocation structure, GemstoneColor[] gemstoneColors) {
        this.unlockAdvancementId = unlockAdvancementId;
        this.structure = structure;
        this.gemstoneColors = gemstoneColors;
    }

    @Contract(pure=true)
    public int getPowderSlotCount() {
        return this.gemstoneColors.length;
    }

    @Contract(pure=true)
    public GemstoneColor[] gemstoneColors() {
        return this.gemstoneColors;
    }

    @Contract(pure=true)
    public static Optional<PedestalTier> getHighestUnlockedRecipeTier(Player playerEntity) {
        if (DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)PedestalTier.COMPLEX.unlockAdvancementId)) {
            return Optional.of(COMPLEX);
        }
        if (DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)PedestalTier.ADVANCED.unlockAdvancementId)) {
            return Optional.of(ADVANCED);
        }
        if (DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)PedestalTier.SIMPLE.unlockAdvancementId)) {
            return Optional.of(SIMPLE);
        }
        if (DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)PedestalTier.BASIC.unlockAdvancementId)) {
            return Optional.of(BASIC);
        }
        return Optional.empty();
    }

    public boolean hasUnlocked(Player playerEntity) {
        return DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)this.unlockAdvancementId);
    }

    public static Optional<PedestalTier> hasJustUnlockedANewRecipeTier(@NotNull ResourceLocation advancementIdentifier) {
        if (advancementIdentifier.equals((Object)PedestalTier.BASIC.unlockAdvancementId)) {
            return Optional.of(BASIC);
        }
        if (advancementIdentifier.equals((Object)PedestalTier.SIMPLE.unlockAdvancementId)) {
            return Optional.of(SIMPLE);
        }
        if (advancementIdentifier.equals((Object)PedestalTier.ADVANCED.unlockAdvancementId)) {
            return Optional.of(ADVANCED);
        }
        if (advancementIdentifier.equals((Object)PedestalTier.COMPLEX.unlockAdvancementId)) {
            return Optional.of(COMPLEX);
        }
        return Optional.empty();
    }

    public static PedestalTier getTier(Optional<Player> player, PedestalBlockEntity pedestal) {
        Level level = pedestal.getLevel();
        BlockPos pos = pedestal.getBlockPos();
        PedestalTier maxTier = pedestal.getVariant().getRecipeTier();
        if (maxTier == BASIC) {
            return BASIC;
        }
        PedestalTier tier = BASIC;
        for (int i = 1; i <= maxTier.ordinal(); ++i) {
            PedestalTier proposal = PedestalTier.values()[i];
            Multiblock multiblock = PedestalTier.getStructureFor(player, proposal);
            if (!multiblock.validate(level, pos.below(), Rotation.NONE)) continue;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                Support.mbCriterion(sl, pos, multiblock);
            }
            tier = proposal;
        }
        return tier;
    }

    private static Multiblock getStructureFor(Optional<Player> player, PedestalTier proposal) {
        if (player.isPresent() && proposal == COMPLEX && !DatabankUtils.hasAdvancement((Player)player.get(), (ResourceLocation)PastelAdvancements.Lategame.BUILD_COMPLEX_PEDESTAL_STRUCTURE_WITHOUT_MOONSTONE)) {
            return PastelMultiblocks.get(PastelMultiblocks.PEDESTAL_COMPLEX_WITHOUT_MOONSTONE);
        }
        return PastelMultiblocks.get(proposal.structure);
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    static {
        CODEC = StringRepresentable.fromEnum(PedestalTier::values);
        STREAM_CODEC = PacketCodecHelper.enumOf(PedestalTier::values);
    }
}

