/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.fusion_shrine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.MultiblockCrafter;
import earth.terrarium.pastel.api.predicate.location.WorldConditionsPredicate;
import earth.terrarium.pastel.api.recipe.FusionShrineRecipeWorldEffect;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.blocks.fusion_shrine.FusionShrineBlockEntity;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.recipe.FluidRecipeInput;
import earth.terrarium.pastel.recipe.GatedStackPastelRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionShrineRecipe
extends GatedStackPastelRecipe<FluidRecipeInput<FluidTank>> {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("build_fusion_shrine");
    protected final List<IngredientStack> craftingInputs;
    protected final FluidIngredient fluid;
    protected final ItemStack output;
    protected final float experience;
    protected final int craftingTime;
    protected final boolean yieldUpgradesDisabled;
    protected final boolean playCraftingFinishedEffects;
    protected final List<WorldConditionsPredicate> worldConditionsPredicates;
    @NotNull
    protected final FusionShrineRecipeWorldEffect startWorldEffect;
    @NotNull
    protected final List<FusionShrineRecipeWorldEffect> duringWorldEffects;
    @NotNull
    protected final FusionShrineRecipeWorldEffect finishWorldEffect;
    @Nullable
    protected final Component description;
    protected final boolean copyComponents;

    public FusionShrineRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, List<IngredientStack> craftingInputs, FluidIngredient fluid, ItemStack output, float experience, int craftingTime, boolean yieldUpgradesDisabled, boolean playCraftingFinishedEffects, boolean copyComponents, List<WorldConditionsPredicate> worldConditionsPredicates, @NotNull FusionShrineRecipeWorldEffect startWorldEffect, @NotNull List<FusionShrineRecipeWorldEffect> duringWorldEffects, @NotNull FusionShrineRecipeWorldEffect finishWorldEffect, @Nullable Component description) {
        super(group, secret, requiredAdvancementIdentifier);
        this.craftingInputs = craftingInputs;
        this.fluid = fluid;
        this.output = output;
        this.experience = experience;
        this.craftingTime = craftingTime;
        this.yieldUpgradesDisabled = yieldUpgradesDisabled;
        this.playCraftingFinishedEffects = playCraftingFinishedEffects;
        this.worldConditionsPredicates = worldConditionsPredicates;
        this.startWorldEffect = startWorldEffect;
        this.duringWorldEffects = duringWorldEffects;
        this.finishWorldEffect = finishWorldEffect;
        this.description = description;
        this.copyComponents = copyComponents;
        this.registerInToastManager(this.getType(), this);
    }

    public boolean matches(FluidRecipeInput<FluidTank> recipeInput, Level world) {
        FluidTank fluidStorage = recipeInput.getTank();
        if (!this.fluid.test(fluidStorage.getFluid())) {
            return false;
        }
        if (!this.fluid.isEmpty() && fluidStorage.getFluidAmount() != fluidStorage.getCapacity()) {
            return false;
        }
        return this.matchIngredientStacksExclusively(recipeInput, this.getIngredientStacks());
    }

    public ItemStack assemble(FluidRecipeInput<FluidTank> inv, HolderLookup.Provider drm) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return this.craftingInputs.size() <= width * height;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.output;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PastelBlocks.FUSION_SHRINE_BASALT.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.FUSION_SHRINE_RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.FUSION_SHRINE;
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return this.craftingInputs;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean areConditionMetCurrently(ServerLevel world, BlockPos pos) {
        if (this.worldConditionsPredicates.isEmpty()) {
            return true;
        }
        return this.worldConditionsPredicates.stream().anyMatch(p -> p.test(world, pos));
    }

    public FluidIngredient getFluid() {
        return this.fluid;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public FusionShrineRecipeWorldEffect getWorldEffectForTick(int tick, int totalTicks) {
        if (tick == 1) {
            return this.startWorldEffect;
        }
        if (tick == totalTicks) {
            return this.finishWorldEffect;
        }
        if (this.duringWorldEffects.isEmpty()) {
            return null;
        }
        if (this.duringWorldEffects.size() == 1) {
            return this.duringWorldEffects.getFirst();
        }
        float parts = (float)totalTicks / (float)this.duringWorldEffects.size();
        int index = (int)((float)tick / parts);
        FusionShrineRecipeWorldEffect effect = this.duringWorldEffects.get(index);
        if (effect.isOneTimeEffect() && index != (int)parts) {
            return null;
        }
        return effect;
    }

    public Optional<Component> getDescription() {
        if (this.description == null) {
            return Optional.empty();
        }
        return Optional.of(this.description);
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "fusion_shrine";
    }

    public void craft(Level world, FusionShrineBlockEntity fusionShrineBlockEntity) {
        ItemStack firstStack = ItemStack.EMPTY;
        ItemStack memory = ItemStack.EMPTY;
        int maxAmount = 1;
        ItemStack output = this.assemble(new FluidRecipeInput<FluidTank>((List<ItemStack>)fusionShrineBlockEntity.getInventory().getInternalList(), fusionShrineBlockEntity.tank), (HolderLookup.Provider)world.registryAccess());
        if (!output.isEmpty()) {
            maxAmount = output.getMaxStackSize();
            block0: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
                for (int i = 0; i < fusionShrineBlockEntity.getContainerSize(); ++i) {
                    ItemStack currentStack = fusionShrineBlockEntity.getItem(i);
                    if (!ingredientStack.test(currentStack)) continue;
                    if (firstStack.isEmpty()) {
                        firstStack = currentStack;
                    }
                    int ingredientStackAmount = ingredientStack.getCount();
                    maxAmount = Math.min(maxAmount, currentStack.getCount() / ingredientStackAmount);
                    continue block0;
                }
            }
            memory = firstStack.copy();
            if (maxAmount > 0) {
                double efficiencyModifier = fusionShrineBlockEntity.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
                this.decrementIngredients(world, fusionShrineBlockEntity, maxAmount, efficiencyModifier);
            }
        } else {
            block2: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
                double efficiencyModifier = fusionShrineBlockEntity.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
                for (int i = 0; i < fusionShrineBlockEntity.getContainerSize(); ++i) {
                    ItemStack currentStack = fusionShrineBlockEntity.getItem(i);
                    if (!ingredientStack.test(currentStack)) continue;
                    int reducedAmountAfterMod = Support.chanceRound((double)ingredientStack.getCount() / efficiencyModifier, world.random);
                    currentStack.shrink(reducedAmountAfterMod);
                    continue block2;
                }
            }
        }
        if (this.copyComponents) {
            ItemEnchantments originalEnchantments = output.getEnchantments();
            output = memory.transmuteCopy((ItemLike)output.getItem(), output.getCount());
            for (Holder enchantment : originalEnchantments.keySet()) {
                output.enchant(enchantment, originalEnchantments.getLevel(enchantment));
            }
        }
        this.spawnCraftingResultAndXP(world, fusionShrineBlockEntity, output, maxAmount);
    }

    private void decrementIngredients(Level world, FusionShrineBlockEntity fusionShrineBlockEntity, int recipesCrafted, double efficiencyModifier) {
        block0: for (IngredientStack ingredientStack : this.getIngredientStacks()) {
            for (int i = 0; i < fusionShrineBlockEntity.getContainerSize(); ++i) {
                ItemStack currentStack = fusionShrineBlockEntity.getItem(i);
                if (!ingredientStack.test(currentStack)) continue;
                int reducedAmount = recipesCrafted * ingredientStack.getCount();
                int reducedAmountAfterMod = efficiencyModifier == 1.0 ? reducedAmount : Support.chanceRound((double)reducedAmount / efficiencyModifier, world.random);
                ItemStack currentRemainder = currentStack.getCraftingRemainingItem();
                currentStack.shrink(reducedAmountAfterMod);
                if (currentRemainder.isEmpty()) continue block0;
                currentRemainder = currentRemainder.copy();
                currentRemainder.setCount(reducedAmountAfterMod);
                InventoryHelper.smartAddToInventory(currentRemainder, (IItemHandlerModifiable)fusionShrineBlockEntity.getInventory(), null);
                continue block0;
            }
        }
    }

    protected void spawnCraftingResultAndXP(@NotNull Level world, @NotNull FusionShrineBlockEntity fusionShrineBlockEntity, @NotNull ItemStack stack, int recipeCount) {
        int resultAmountBeforeMod = recipeCount * stack.getCount();
        double yieldModifier = this.yieldUpgradesDisabled ? 1.0 : (double)fusionShrineBlockEntity.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.YIELD);
        int resultAmountAfterMod = Support.chanceRound((double)resultAmountBeforeMod * yieldModifier, world.random);
        int intExperience = Support.chanceRound((float)recipeCount * this.experience, world.random);
        MultiblockCrafter.spawnItemStackAsEntitySplitViaMaxCount(world, fusionShrineBlockEntity.getBlockPos().above(2), stack, resultAmountAfterMod, MultiblockCrafter.RECIPE_STACK_VELOCITY);
        if (this.experience > 0.0f) {
            MultiblockCrafter.spawnExperience(world, fusionShrineBlockEntity.getBlockPos(), intExperience);
        }
        fusionShrineBlockEntity.grantCriterion(stack, intExperience);
    }

    public boolean shouldPlayCraftingFinishedEffects() {
        return this.playCraftingFinishedEffects;
    }

    public static class Serializer
    implements RecipeSerializer<FusionShrineRecipe> {
        public static final MapCodec<FusionShrineRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)IngredientStack.CODEC.listOf(0, 7).fieldOf("ingredients").forGetter(recipe -> recipe.craftingInputs), (App)FluidIngredient.CODEC.optionalFieldOf("fluid", (Object)FluidIngredient.empty()).forGetter(recipe -> recipe.fluid), (App)ItemStack.CODEC.optionalFieldOf("result", (Object)ItemStack.EMPTY).forGetter(recipe -> recipe.output), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(recipe -> recipe.craftingTime), (App)Codec.BOOL.optionalFieldOf("disable_yield_upgrades", (Object)false).forGetter(recipe -> recipe.yieldUpgradesDisabled), (App)Codec.BOOL.optionalFieldOf("play_crafting_finished_effects", (Object)true).forGetter(recipe -> recipe.playCraftingFinishedEffects), (App)Codec.BOOL.optionalFieldOf("copy_components", (Object)false).forGetter(recipe -> recipe.copyComponents), (App)CodecHelper.singleOrList(WorldConditionsPredicate.CODEC).optionalFieldOf("world_conditions", List.of()).forGetter(recipe -> recipe.worldConditionsPredicates), (App)FusionShrineRecipeWorldEffect.CODEC.fieldOf("start_crafting_effect").forGetter(recipe -> recipe.startWorldEffect), (App)FusionShrineRecipeWorldEffect.CODEC.listOf().optionalFieldOf("during_crafting_effects", List.of()).forGetter(recipe -> recipe.duringWorldEffects), (App)FusionShrineRecipeWorldEffect.CODEC.fieldOf("finish_crafting_effect").forGetter(recipe -> recipe.finishWorldEffect), (App)ComponentSerialization.CODEC.optionalFieldOf("description", (Object)Component.empty()).forGetter(recipe -> recipe.description)).apply((Applicative)i, FusionShrineRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FusionShrineRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, ByteBufCodecs.BOOL, recipe -> recipe.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), recipe -> recipe.requiredAdvancementIdentifier, IngredientStack.STREAM_CODEC.apply(ByteBufCodecs.list((int)7)), recipe -> recipe.craftingInputs, FluidIngredient.STREAM_CODEC, recipe -> recipe.fluid, ItemStack.OPTIONAL_STREAM_CODEC, recipe -> recipe.output, ByteBufCodecs.FLOAT, recipe -> Float.valueOf(recipe.experience), ByteBufCodecs.VAR_INT, recipe -> recipe.craftingTime, ByteBufCodecs.BOOL, recipe -> recipe.yieldUpgradesDisabled, ByteBufCodecs.BOOL, recipe -> recipe.playCraftingFinishedEffects, ByteBufCodecs.BOOL, recipe -> recipe.copyComponents, WorldConditionsPredicate.STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.worldConditionsPredicates, FusionShrineRecipeWorldEffect.STREAM_CODEC, recipe -> recipe.startWorldEffect, FusionShrineRecipeWorldEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.duringWorldEffects, FusionShrineRecipeWorldEffect.STREAM_CODEC, recipe -> recipe.finishWorldEffect, ComponentSerialization.TRUSTED_CONTEXT_FREE_STREAM_CODEC, recipe -> recipe.description, FusionShrineRecipe::new);

        public MapCodec<FusionShrineRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FusionShrineRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

