/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.fluid_converting;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.recipe.fluid_converting.FluidConvertingRecipe;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DragonrotConvertingRecipe
extends FluidConvertingRecipe {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("hidden/interact_with_dragonrot");
    private static final Set<Item> outputItems = new HashSet<Item>();

    public DragonrotConvertingRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, @NotNull Ingredient inputIngredient, ItemStack outputItemStack) {
        super(group, secret, requiredAdvancementIdentifier, inputIngredient, outputItemStack);
        outputItems.add(outputItemStack.getItem());
    }

    public static boolean isExistingOutputItem(@NotNull ItemStack itemStack) {
        return outputItems.contains(itemStack.getItem());
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PastelItems.DRAGONROT_BUCKET.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.DRAGONROT_CONVERTING_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.DRAGONROT_CONVERTING;
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "dragonrot_converting";
    }
}

