/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class RecipeUtils {
    public static ItemStack itemStackWithNbtFromJson(JsonObject json) {
        Item item = (Item)BuiltInRegistries.ITEM.byNameCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int count = GsonHelper.getAsInt((JsonObject)json, (String)"count", (int)1);
        if (count < 1) {
            throw new JsonSyntaxException("Invalid output count: " + count);
        }
        ItemStack stack = new ItemStack((ItemLike)item, count);
        return stack;
    }

    public static BlockState blockStateFromString(String string) throws CommandSyntaxException {
        return BlockStateParser.parseForBlock((HolderLookup)BuiltInRegistries.BLOCK.asLookup(), (StringReader)new StringReader(string), (boolean)true).blockState();
    }

    public static DataResult<BlockState> blockStateDataFromString(String string) {
        try {
            return DataResult.success((Object)RecipeUtils.blockStateFromString(string));
        }
        catch (CommandSyntaxException e) {
            return DataResult.error(() -> ((CommandSyntaxException)e).getMessage());
        }
    }

    public static String blockStateToString(BlockState state) {
        return BlockStateParser.serialize((BlockState)state);
    }
}

