/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class InkConvertingRecipe
extends GatedPastelRecipe<RecipeInput> {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("midgame/place_color_picker");
    protected static final List<Item> INPUT_ITEMS = new ArrayList<Item>();
    protected final Ingredient inputIngredient;
    protected final InkColor color;
    protected final long amount;

    public InkConvertingRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, Ingredient inputIngredient, InkColor color, long amount) {
        super(group, secret, requiredAdvancementIdentifier);
        this.inputIngredient = inputIngredient;
        this.color = color;
        this.amount = amount;
        for (ItemStack itemStack : inputIngredient.getItems()) {
            Item item = itemStack.getItem();
            if (INPUT_ITEMS.contains(item)) continue;
            INPUT_ITEMS.add(item);
        }
        this.registerInToastManager(this.getType(), this);
    }

    public static boolean isInput(Item item) {
        return INPUT_ITEMS.contains(item);
    }

    public boolean matches(RecipeInput inv, Level world) {
        return this.inputIngredient.test(inv.getItem(0));
    }

    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider drm) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return ItemStack.EMPTY;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PastelBlocks.COLOR_PICKER.get());
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return UNLOCK_IDENTIFIER;
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.INK_CONVERTING_RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.INK_CONVERTING;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.of(), (Object[])new Ingredient[]{this.inputIngredient});
    }

    @Override
    public String getRecipeTypeShortID() {
        return "ink_converting";
    }

    public InkColor getInkColor() {
        return this.color;
    }

    public long getInkAmount() {
        return this.amount;
    }

    public static class Serializer
    implements RecipeSerializer<InkConvertingRecipe> {
        public static final MapCodec<InkConvertingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.inputIngredient), (App)InkColor.CODEC.fieldOf("ink_color").forGetter(recipe -> recipe.color), (App)Codec.LONG.fieldOf("amount").forGetter(recipe -> recipe.amount)).apply((Applicative)i, InkConvertingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InkConvertingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, (StreamCodec)ByteBufCodecs.BOOL, recipe -> recipe.secret, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), recipe -> recipe.requiredAdvancementIdentifier, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.inputIngredient, InkColor.STREAM_CODEC, recipe -> recipe.color, (StreamCodec)ByteBufCodecs.VAR_LONG, recipe -> recipe.amount, InkConvertingRecipe::new);

        public MapCodec<InkConvertingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InkConvertingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

