/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.toast;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MessageToast
implements Toast {
    private final ResourceLocation TEXTURE = PastelCommon.locate("textures/gui/toasts.png");
    private final ItemStack itemStack;
    private final Component titleText;
    private final Component messageText;
    private final SoundEvent soundEvent;
    private boolean soundPlayed;

    public MessageToast(ItemStack itemStack, String text) {
        this.itemStack = itemStack;
        this.soundEvent = PastelSounds.NEW_REVELATION;
        this.titleText = Component.translatable((String)("pastel.toast.message." + text + ".title"));
        this.messageText = Component.translatable((String)("pastel.toast.message." + text + ".text"));
        this.soundPlayed = false;
    }

    public static void showMessageToast(Minecraft client, ItemStack itemStack, String string) {
        client.getToasts().addToast((Toast)new MessageToast(itemStack, string));
    }

    public Toast.Visibility render(GuiGraphics drawContext, ToastComponent manager, long startTime) {
        drawContext.blit(this.TEXTURE, 0, 0, 0, 0, this.width(), this.height());
        Minecraft client = manager.getMinecraft();
        Font textRenderer = client.font;
        List wrappedText = textRenderer.split((FormattedText)this.messageText, 125);
        List wrappedTitle = textRenderer.split((FormattedText)this.titleText, 125);
        long toastTimeMilliseconds = PastelCommon.CONFIG.ToastTimeMilliseconds;
        if (startTime < toastTimeMilliseconds / 2L) {
            int l = Mth.floor((float)(Mth.clamp((float)((float)(toastTimeMilliseconds / 2L - startTime) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            int halfHeight = this.height() / 2;
            int titleSize = wrappedTitle.size();
            int m = halfHeight - titleSize * 9 / 2;
            for (FormattedCharSequence orderedText : wrappedTitle) {
                drawContext.drawString(textRenderer, orderedText, 30, m, 0x323232 | l, false);
                m += 9;
            }
        } else {
            int l = Mth.floor((float)(Mth.clamp((float)((float)(startTime - toastTimeMilliseconds / 2L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int halfHeight = this.height() / 2;
            int textSize = wrappedText.size();
            int m = halfHeight - textSize * 9 / 2;
            for (FormattedCharSequence orderedText : wrappedText) {
                drawContext.drawString(textRenderer, orderedText, 30, m, l, false);
                m += 9;
            }
        }
        if (!this.soundPlayed && startTime > 0L) {
            this.soundPlayed = true;
            if (this.soundEvent != null) {
                manager.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.soundEvent, (float)1.0f, (float)0.75f));
            }
        }
        drawContext.renderItem(this.itemStack, 8, 8);
        return startTime >= toastTimeMilliseconds ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

