/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.entity.PastelFishingBobberEntity;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class PastelFishingRodHookedCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("fishing_rod_hooked");

    public void trigger(ServerPlayer player, ItemStack rod, PastelFishingBobberEntity bobber, Entity fishedEntity, Collection<ItemStack> fishingLoots) {
        LootContext bobberContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)bobber);
        LootContext hookedEntityContext = bobber.getHookedEntity() == null ? null : EntityPredicate.createContext((ServerPlayer)player, (Entity)bobber.getHookedEntity());
        LootContext fishedEntityContext = fishedEntity == null ? null : EntityPredicate.createContext((ServerPlayer)player, (Entity)fishedEntity);
        this.trigger(player, conditions -> conditions.matches(rod, bobberContext, hookedEntityContext, fishedEntityContext, fishingLoots, (ServerLevel)bobber.level(), bobber.blockPosition()));
        LootContext hookedEntityOrBobberContext = EntityPredicate.createContext((ServerPlayer)player, (Entity)(bobber.getHookedEntity() != null ? bobber.getHookedEntity() : bobber));
        CriteriaTriggers.FISHING_ROD_HOOKED.trigger(player, conditions -> conditions.matches(rod, hookedEntityOrBobberContext, fishingLoots));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> rod, Optional<ContextAwarePredicate> bobber, Optional<ContextAwarePredicate> hookedEntity, Optional<ContextAwarePredicate> fishedEntity, Optional<ItemPredicate> caughtItem, Optional<FluidPredicate> fluidPredicate) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.optionalFieldOf("rod").forGetter(Conditions::rod), (App)ContextAwarePredicate.CODEC.optionalFieldOf("bobber").forGetter(Conditions::bobber), (App)ContextAwarePredicate.CODEC.optionalFieldOf("fishing").forGetter(Conditions::hookedEntity), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("fished_entity").forGetter(Conditions::fishedEntity), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(Conditions::caughtItem), (App)FluidPredicate.CODEC.optionalFieldOf("fluid").forGetter(Conditions::fluidPredicate)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ItemStack rod, LootContext bobberContext, LootContext hookedEntityContext, LootContext fishedEntityContext, Collection<ItemStack> fishingLoots, ServerLevel world, BlockPos blockPos) {
            if (this.rod.isPresent() && !this.rod.get().test(rod)) {
                return false;
            }
            if (this.bobber.isPresent() && !this.bobber.get().matches(bobberContext)) {
                return false;
            }
            if (this.fluidPredicate.isPresent() && !this.fluidPredicate.get().matches(world, blockPos)) {
                return false;
            }
            if (fishedEntityContext != null && !this.fishedEntity.map(e -> e.matches(fishedEntityContext)).orElse(true).booleanValue()) {
                return false;
            }
            if (hookedEntityContext != null && !this.hookedEntity.map(e -> e.matches(hookedEntityContext)).orElse(true).booleanValue()) {
                return false;
            }
            if (this.caughtItem.isPresent()) {
                Entity entity;
                if (hookedEntityContext != null && (entity = (Entity)hookedEntityContext.getParamOrNull(LootContextParams.THIS_ENTITY)) instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entity;
                    if (this.caughtItem.get().test(itemEntity.getItem())) {
                        return true;
                    }
                }
                for (ItemStack itemStack : fishingLoots) {
                    if (!this.caughtItem.get().test(itemStack)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

