/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class PairedFoodEatenCriterion
extends SimpleCriterionTrigger<Conditions> {
    public static final ResourceLocation ID = PastelCommon.locate("consumed_paired_food");

    public void trigger(ServerPlayer player, ItemStack eatenStack, ItemStack pairedStack) {
        this.trigger(player, conditions -> conditions.matches(eatenStack, pairedStack));
    }

    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> eatenItem, Optional<ItemPredicate> pairedItem) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.optionalFieldOf("eaten_item").forGetter(Conditions::eatenItem), (App)ItemPredicate.CODEC.optionalFieldOf("paired_item").forGetter(Conditions::pairedItem)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ItemStack eatenStack, ItemStack pairedStack) {
            if (this.eatenItem.isPresent() && !this.eatenItem.get().test(eatenStack)) {
                return false;
            }
            return this.pairedItem.isEmpty() || this.pairedItem.get().test(pairedStack);
        }
    }
}

