/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.progression;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.recipe.GatedRecipe;
import earth.terrarium.pastel.progression.toast.MessageToast;
import earth.terrarium.pastel.progression.toast.UnlockedRecipeToast;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class UnlockToastManager {
    public static final Map<ResourceLocation, Map<RecipeType<?>, Set<GatedRecipe<?>>>> gatedRecipes = new HashMap();
    public static final Map<ResourceLocation, Tuple<ItemStack, String>> MESSAGE_TOASTS = new HashMap<ResourceLocation, Tuple<ItemStack, String>>(){
        {
            this.put(PastelAdvancements.Milestones.UNLOCK_SHOOTING_STARS, new Tuple((Object)Items.SPYGLASS.getDefaultInstance(), (Object)"shooting_stars_unlocked"));
            this.put(PastelAdvancements.Milestones.UNLOCK_OVERENCHANTING_WITH_ENCHANTER, new Tuple((Object)((Block)PastelBlocks.ENCHANTER.get()).asItem().getDefaultInstance(), (Object)"overchanting_unlocked"));
            this.put(PastelAdvancements.Milestones.UNLOCK_CONFLICTED_ENCHANTING_WITH_ENCHANTER, new Tuple((Object)((Block)PastelBlocks.ENCHANTER.get()).asItem().getDefaultInstance(), (Object)"enchant_conflicting_enchantments_unlocked"));
            this.put(PastelAdvancements.Milestones.UNLOCK_FOURTH_POTION_WORKSHOP_REAGENT_SLOT, new Tuple((Object)((Block)PastelBlocks.POTION_WORKSHOP.get()).asItem().getDefaultInstance(), (Object)"fourth_potion_reagent_unlocked"));
            this.put(PastelAdvancements.Midgame.PASTEL_MIDGAME, new Tuple((Object)((Block)PastelBlocks.PEDESTAL_ONYX.get()).asItem().getDefaultInstance(), (Object)"second_advancement_tree_unlocked"));
            this.put(PastelAdvancements.Lategame.PASTEL_LATEGAME, new Tuple((Object)((Block)PastelBlocks.PEDESTAL_MOONSTONE.get()).asItem().getDefaultInstance(), (Object)"third_advancement_tree_unlocked"));
            this.put(PastelAdvancements.ASCEND_KINDLING, new Tuple((Object)((Block)PastelBlocks.PEDESTAL_MOONSTONE.get()).asItem().getDefaultInstance(), (Object)"ascend_kindling"));
            this.put(PastelCommon.locate("mod_integration/neepmeat/vivisect_kindling"), new Tuple((Object)((Item)PastelItems.DIVINATION_HEART.get()).getDefaultInstance(), (Object)"vivisect_kindling"));
            this.put(PastelAdvancements.COLLECT_PIGMENT, new Tuple((Object)((Item)PastelItems.PAINTBRUSH.get()).getDefaultInstance(), (Object)"block_coloring_unlocked"));
            this.put(PastelAdvancements.Midgame.FILL_INK_CONTAINER, new Tuple((Object)((Item)PastelItems.PAINTBRUSH.get()).getDefaultInstance(), (Object)"ink_slinging_unlocked"));
            this.put(PastelAdvancements.Milestones.UNLOCK_PASTEL_NODE_COLORING, new Tuple((Object)((Block)PastelBlocks.SENDER_NODE.get()).asItem().getDefaultInstance(), (Object)"pastel_node_coloring"));
        }
    };

    public static void clear() {
        gatedRecipes.clear();
    }

    public static void registerGatedRecipe(RecipeType<?> recipeType, GatedRecipe<?> gatedRecipe) {
        ResourceLocation requiredAdvancementIdentifier = gatedRecipe.advancementID().orElse(null);
        if (gatedRecipe.isSecret()) {
            return;
        }
        if (gatedRecipes.containsKey(requiredAdvancementIdentifier)) {
            Map<RecipeType<?>, Set<GatedRecipe<?>>> recipeTypeListMap = gatedRecipes.get(requiredAdvancementIdentifier);
            if (recipeTypeListMap.containsKey(recipeType)) {
                Set<GatedRecipe<?>> existingSet = recipeTypeListMap.get(recipeType);
                existingSet.add(gatedRecipe);
            } else {
                ObjectArraySet newList = new ObjectArraySet();
                newList.add(gatedRecipe);
                recipeTypeListMap.put(recipeType, (Set<GatedRecipe<?>>)newList);
            }
        } else {
            HashMap recipeTypeListSet = new HashMap();
            ObjectArraySet newSet = new ObjectArraySet();
            newSet.add(gatedRecipe);
            recipeTypeListSet.put(recipeType, newSet);
            gatedRecipes.put(requiredAdvancementIdentifier, recipeTypeListSet);
        }
    }

    public static void processAdvancements(Set<ResourceLocation> doneAdvancements) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        RegistryAccess registryManager = client.level.registryAccess();
        int unlockedRecipeCount = 0;
        HashMap unlockedRecipesByType = new HashMap();
        ArrayList<Tuple<ItemStack, String>> specialToasts = new ArrayList<Tuple<ItemStack, String>>();
        for (ResourceLocation resourceLocation : doneAdvancements) {
            Optional<PedestalTier> newlyUnlockedRecipeTier;
            if (gatedRecipes.containsKey(resourceLocation)) {
                Map<RecipeType<?>, Set<GatedRecipe<?>>> recipesGatedByAdvancement = gatedRecipes.get(resourceLocation);
                for (Map.Entry<RecipeType<?>, Set<GatedRecipe<?>>> recipesByType : recipesGatedByAdvancement.entrySet()) {
                    List newRecipes = unlockedRecipesByType.containsKey(recipesByType.getKey()) ? (List)unlockedRecipesByType.get(recipesByType.getKey()) : new ArrayList();
                    for (GatedRecipe<?> unlockedRecipe : recipesByType.getValue()) {
                        if (!unlockedRecipe.canPlayerCraft((Player)client.player) || newRecipes.contains(unlockedRecipe)) continue;
                        newRecipes.add(unlockedRecipe);
                        ++unlockedRecipeCount;
                    }
                    unlockedRecipesByType.put(recipesByType.getKey(), newRecipes);
                }
            }
            if ((newlyUnlockedRecipeTier = PedestalTier.hasJustUnlockedANewRecipeTier(resourceLocation)).isPresent()) {
                List unlockedPedestalRecipes = unlockedRecipesByType.containsKey(PastelRecipeTypes.PEDESTAL) ? (List)unlockedRecipesByType.get(PastelRecipeTypes.PEDESTAL) : new ArrayList();
                ArrayList pedestalRecipes = new ArrayList();
                for (Map<RecipeType<?>, Set<GatedRecipe<?>>> recipesByType : gatedRecipes.values()) {
                    if (!recipesByType.containsKey(PastelRecipeTypes.PEDESTAL)) continue;
                    pedestalRecipes.addAll((Collection)recipesByType.get(PastelRecipeTypes.PEDESTAL));
                }
                for (PedestalRecipe alreadyUnlockedRecipe : UnlockToastManager.getRecipesForTierWithAllConditionsMet(newlyUnlockedRecipeTier.get(), pedestalRecipes)) {
                    if (unlockedPedestalRecipes.contains(alreadyUnlockedRecipe)) continue;
                    unlockedPedestalRecipes.add(alreadyUnlockedRecipe);
                }
            }
            if (!MESSAGE_TOASTS.containsKey(resourceLocation)) continue;
            specialToasts.add(MESSAGE_TOASTS.get(resourceLocation));
        }
        if (unlockedRecipeCount > 50) {
            ArrayList<ItemStack> allStacks = new ArrayList<ItemStack>();
            for (List recipes : unlockedRecipesByType.values()) {
                for (GatedRecipe recipe : recipes) {
                    allStacks.add(recipe.getResultItem((HolderLookup.Provider)client.level.registryAccess()));
                }
            }
            UnlockedRecipeToast.showLotsOfRecipesToast(Minecraft.getInstance(), allStacks);
        } else {
            for (List list : unlockedRecipesByType.values()) {
                UnlockToastManager.showGroupedRecipeUnlockToasts(registryManager, list);
            }
        }
        for (Tuple tuple : specialToasts) {
            MessageToast.showMessageToast(Minecraft.getInstance(), (ItemStack)tuple.getA(), (String)tuple.getB());
        }
    }

    private static void showGroupedRecipeUnlockToasts(RegistryAccess registryManager, List<GatedRecipe<?>> unlockedRecipes) {
        if (unlockedRecipes.isEmpty()) {
            return;
        }
        Component singleText = unlockedRecipes.getFirst().getSingleUnlockToastString();
        Component multipleText = unlockedRecipes.getFirst().getMultipleUnlockToastString();
        ArrayList<ItemStack> singleRecipes = new ArrayList<ItemStack>();
        HashMap groupedRecipes = new HashMap();
        for (GatedRecipe<?> gatedRecipe : unlockedRecipes) {
            if (gatedRecipe.getResultItem((HolderLookup.Provider)registryManager).isEmpty()) continue;
            if (gatedRecipe.getGroup().isEmpty()) {
                singleRecipes.add(gatedRecipe.getResultItem((HolderLookup.Provider)registryManager));
                continue;
            }
            if (groupedRecipes.containsKey(gatedRecipe.getGroup())) {
                ((List)groupedRecipes.get(gatedRecipe.getGroup())).add(gatedRecipe.getResultItem((HolderLookup.Provider)registryManager));
                continue;
            }
            ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
            newList.add(gatedRecipe.getResultItem((HolderLookup.Provider)registryManager));
            groupedRecipes.put(gatedRecipe.getGroup(), newList);
        }
        if (!groupedRecipes.isEmpty()) {
            for (Map.Entry entry : groupedRecipes.entrySet()) {
                List groupedList = (List)entry.getValue();
                if (groupedList.size() == 1) {
                    UnlockedRecipeToast.showRecipeToast(Minecraft.getInstance(), (ItemStack)groupedList.getFirst(), singleText);
                    continue;
                }
                UnlockedRecipeToast.showRecipeGroupToast(Minecraft.getInstance(), (String)entry.getKey(), groupedList, multipleText);
            }
        }
        for (ItemStack itemStack : singleRecipes) {
            UnlockedRecipeToast.showRecipeToast(Minecraft.getInstance(), itemStack, singleText);
        }
    }

    @NotNull
    private static List<PedestalRecipe> getRecipesForTierWithAllConditionsMet(PedestalTier pedestalRecipeTier, List<GatedRecipe<?>> pedestalRecipes) {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        ArrayList<PedestalRecipe> alreadyUnlockedRecipesAtNewTier = new ArrayList<PedestalRecipe>();
        for (GatedRecipe<?> recipe : pedestalRecipes) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)recipe;
            if (pedestalRecipe.getTier() != pedestalRecipeTier || alreadyUnlockedRecipesAtNewTier.contains(recipe) || !recipe.canPlayerCraft((Player)player)) continue;
            alreadyUnlockedRecipesAtNewTier.add(pedestalRecipe);
        }
        return alreadyUnlockedRecipesAtNewTier;
    }
}

