/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.render;

import com.google.common.collect.EvictingQueue;
import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.pastel.particle.render.EarlyRenderingParticle;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EarlyRenderingParticleContainer {
    private static final int MAX_PARTICLES = 16384;
    private static final Map<ParticleRenderType, Queue<EarlyRenderingParticle>> particles = new Object2ReferenceOpenHashMap();

    public void add(Particle particle) {
        if (particle instanceof EarlyRenderingParticle) {
            EarlyRenderingParticle earlyRenderingParticle = (EarlyRenderingParticle)particle;
            particles.computeIfAbsent(particle.getRenderType(), sheet -> EvictingQueue.create((int)16384)).add(earlyRenderingParticle);
        }
    }

    public void removeDead() {
        for (Queue<EarlyRenderingParticle> particles : EarlyRenderingParticleContainer.particles.values()) {
            particles.removeIf(particle -> !((Particle)particle).isAlive());
        }
    }

    public static void clear() {
        particles.clear();
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, Camera camera, float tickDelta) {
        for (Queue<EarlyRenderingParticle> particles : EarlyRenderingParticleContainer.particles.values()) {
            for (EarlyRenderingParticle particle : particles) {
                particle.renderAsEntity(matrices, vertexConsumers, camera, tickDelta);
            }
        }
    }
}

