/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ZigZagParticle
extends TextureSheetParticle {
    protected ZigZagParticle(ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
        this.gravity = 0.0f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.quadSize *= 0.75f;
        this.hasPhysics = false;
    }

    public void tick() {
        super.tick();
        if (this.age % 8 == 0) {
            switch (this.level.random.nextInt(6)) {
                case 1: {
                    this.setParticleSpeed(this.xd, this.zd, this.yd);
                }
                case 2: {
                    this.setParticleSpeed(this.zd, this.yd, this.xd);
                }
                case 3: {
                    this.setParticleSpeed(this.zd, this.xd, this.yd);
                }
                case 4: {
                    this.setParticleSpeed(this.yd, this.xd, this.zd);
                }
            }
            this.setParticleSpeed(this.yd, this.zd, this.xd);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float tint) {
        float f = ((float)this.age + tint) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(tint);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            ZigZagParticle craftingParticle = new ZigZagParticle(clientWorld, x, y, z, velocityX, velocityY, velocityZ);
            craftingParticle.setLifetime((int)(8.0 / (clientWorld.random.nextDouble() * 0.8 + 0.2)));
            craftingParticle.pickSprite(this.spriteProvider);
            return craftingParticle;
        }
    }
}

