/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import earth.terrarium.pastel.helpers.data.ColorHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class TranslucentSplashParticle
extends WaterDropParticle {
    protected TranslucentSplashParticle(ClientLevel clientWorld, double d, double e, double f) {
        super(clientWorld, d, e, f);
        Vector3f waterColor = ColorHelper.colorIntToVec(BiomeColors.getAverageWaterColor((BlockAndTintGetter)this.level, (BlockPos)BlockPos.containing((double)this.x, (double)this.y, (double)this.z)));
        this.rCol = waterColor.x;
        this.gCol = waterColor.y;
        this.bCol = waterColor.z;
        this.quadSize *= 0.667f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            TranslucentSplashParticle rainSplashParticle = new TranslucentSplashParticle(clientWorld, d, e, f);
            rainSplashParticle.pickSprite(this.spriteProvider);
            return rainSplashParticle;
        }
    }
}

