/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BaseAshSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class QuartzFluffParticle
extends BaseAshSmokeParticle {
    protected QuartzFluffParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, float scaleMultiplier, SpriteSet spriteProvider) {
        super(world, x, y, z, 0.0725f, -0.1f, 0.0725f, velocityX, velocityY, velocityZ, scaleMultiplier, spriteProvider, 1.0f, 0, 0.08f, false);
        this.alpha = 0.0f;
        this.lifetime = 15 + world.random.nextInt(16);
        this.quadSize = (0.25f + this.random.nextFloat() * 0.5f) * 0.25f;
        this.rCol = 1.0f;
        this.gCol = 0.975f;
        this.bCol = 0.9125f;
    }

    public void tick() {
        super.tick();
        this.adjustAlpha();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private void adjustAlpha() {
        if (this.age <= 7) {
            this.alpha = Mth.clamp((float)((float)this.age / 7.0f), (float)0.0f, (float)1.0f);
            return;
        }
        float ageFade = Mth.clamp((float)((float)Math.min(this.lifetime - this.age, 7) / 7.0f), (float)0.0f, (float)1.0f);
        this.alpha = ageFade < 1.0f ? Math.min(this.alpha, ageFade) : (this.onGround ? Mth.clamp((float)(this.alpha - 0.02f), (float)0.0f, (float)1.0f) : Mth.clamp((float)(this.alpha + 0.05f), (float)0.0f, (float)1.0f));
        if (this.alpha < 0.01f) {
            this.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new QuartzFluffParticle(clientWorld, d, e, f, 0.0, 0.0, 0.0, 1.0f, this.spriteProvider);
        }
    }
}

