/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.particle.client;

import earth.terrarium.pastel.particle.effect.ColoredSporeBlossomAirParticleEffect;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.SuspendedParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ColoredWaterSuspendParticle
extends SuspendedParticle {
    public ColoredWaterSuspendParticle(ClientLevel world, SpriteSet spriteProvider, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        super(world, spriteProvider, x, y, z, velocityX, velocityY, velocityZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<ColoredSporeBlossomAirParticleEffect> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public TextureSheetParticle createParticle(ColoredSporeBlossomAirParticleEffect parameters, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            Vector3f color = parameters.getColor();
            ColoredWaterSuspendParticle particle = new ColoredWaterSuspendParticle(this, world, this.spriteProvider, x, y, z, 0.0, -0.8f, 0.0){

                public Optional<ParticleGroup> getParticleGroup() {
                    return Optional.of(ParticleGroup.SPORE_BLOSSOM);
                }
            };
            particle.setLifetime(Mth.randomBetweenInclusive((RandomSource)world.random, (int)500, (int)1000));
            particle.gravity = 0.01f;
            particle.setColor(color.x, color.y, color.z);
            return particle;
        }
    }
}

