/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.particle.effect.TransmissionParticleEffect;
import earth.terrarium.pastel.particle.effect.TypedTransmission;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record TypedTransmissionPayload(TypedTransmission transmission) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TypedTransmissionPayload> ID = PastelC2SPackets.makeId("typed_transmission");
    public static final StreamCodec<RegistryFriendlyByteBuf, TypedTransmissionPayload> CODEC = StreamCodec.composite(TypedTransmission.STREAM_CODEC, TypedTransmissionPayload::transmission, TypedTransmissionPayload::new);

    public static void playTransmissionParticle(ServerLevel world, @NotNull TypedTransmission transmission) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(BlockPos.containing((Position)transmission.getOrigin())), (CustomPacketPayload)new TypedTransmissionPayload(transmission), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(TypedTransmissionPayload payload, IPayloadContext context) {
        Level level = context.player().level();
        TypedTransmission transmission = payload.transmission();
        switch (transmission.getVariant()) {
            case BLOCK_POS: {
                level.addAlwaysVisibleParticle((ParticleOptions)new TransmissionParticleEffect(PastelParticleTypes.BLOCK_POS_EVENT_TRANSMISSION, transmission.getDestination(), transmission.getArrivalInTicks()), true, transmission.getOrigin().x(), transmission.getOrigin().y(), transmission.getOrigin().z(), 0.0, 0.0, 0.0);
                break;
            }
            case ITEM: {
                level.addAlwaysVisibleParticle((ParticleOptions)new TransmissionParticleEffect(PastelParticleTypes.ITEM_TRANSMISSION, transmission.getDestination(), transmission.getArrivalInTicks()), true, transmission.getOrigin().x(), transmission.getOrigin().y(), transmission.getOrigin().z(), 0.0, 0.0, 0.0);
                break;
            }
            case EXPERIENCE: {
                level.addAlwaysVisibleParticle((ParticleOptions)new TransmissionParticleEffect(PastelParticleTypes.EXPERIENCE_TRANSMISSION, transmission.getDestination(), transmission.getArrivalInTicks()), true, transmission.getOrigin().x(), transmission.getOrigin().y(), transmission.getOrigin().z(), 0.0, 0.0, 0.0);
                break;
            }
            case HUMMINGSTONE: {
                level.addAlwaysVisibleParticle((ParticleOptions)new TransmissionParticleEffect(PastelParticleTypes.HUMMINGSTONE_TRANSMISSION, transmission.getDestination(), transmission.getArrivalInTicks()), true, transmission.getOrigin().x(), transmission.getOrigin().y(), transmission.getOrigin().z(), 0.0, 0.0, 0.0);
                break;
            }
            case REDSTONE: {
                level.addAlwaysVisibleParticle((ParticleOptions)new TransmissionParticleEffect(PastelParticleTypes.WIRELESS_REDSTONE_TRANSMISSION, transmission.getDestination(), transmission.getArrivalInTicks()), true, transmission.getOrigin().x(), transmission.getOrigin().y(), transmission.getOrigin().z(), 0.0, 0.0, 0.0);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

