/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.items.map.ArtisansAtlasState;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.PacketListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncArtisansAtlasPayload(Optional<ResourceLocation> targetId, ClientboundMapItemDataPacket packet) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncArtisansAtlasPayload> ID = PastelC2SPackets.makeId("sync_artisans_atlas");
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncArtisansAtlasPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), SyncArtisansAtlasPayload::targetId, (StreamCodec)ClientboundMapItemDataPacket.STREAM_CODEC, SyncArtisansAtlasPayload::packet, SyncArtisansAtlasPayload::new);

    public static void execute(SyncArtisansAtlasPayload payload, IPayloadContext context) {
        SyncArtisansAtlasPayload.execute(payload);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void execute(SyncArtisansAtlasPayload payload) {
        Minecraft client = Minecraft.getInstance();
        ClientLevel level = client.level;
        if (level == null) {
            return;
        }
        PacketUtils.ensureRunningOnSameThread((Packet)payload.packet, (PacketListener)client.getConnection(), (BlockableEventLoop)client);
        MapRenderer mapRenderer = client.gameRenderer.getMapRenderer();
        MapId mapIdComponent = payload.packet.mapId();
        MapItemSavedData mapState = level.getMapData(mapIdComponent);
        if (mapState == null) {
            mapState = new ArtisansAtlasState(payload.packet.scale(), payload.packet.locked(), (ResourceKey<Level>)level.dimension());
            level.overrideMapData(mapIdComponent, mapState);
        }
        if (payload.packet.decorations().isPresent()) {
            mapState.addClientSideDecorations((List)payload.packet.decorations().get());
        }
        if (payload.packet.colorPatch().isPresent()) {
            ((MapItemSavedData.MapPatch)payload.packet.colorPatch().get()).applyToMap(mapState);
        }
        if (mapState instanceof ArtisansAtlasState) {
            ArtisansAtlasState artisansAtlasState = (ArtisansAtlasState)mapState;
            artisansAtlasState.setTargetId(payload.targetId.orElse(null));
        }
        mapRenderer.update(mapIdComponent, mapState);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

