/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.api.color.ColorRegistry;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.particle.VectorPattern;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.particle.effect.DynamicParticleEffect;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record PlayFusionCraftingFinishedParticlePayload(BlockPos pos, InkColor color) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayFusionCraftingFinishedParticlePayload> ID = PastelC2SPackets.makeId("play_fusion_crafting_finished_particle");
    public static final StreamCodec<FriendlyByteBuf, PlayFusionCraftingFinishedParticlePayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PlayFusionCraftingFinishedParticlePayload::pos, InkColor.STREAM_CODEC, PlayFusionCraftingFinishedParticlePayload::color, PlayFusionCraftingFinishedParticlePayload::new);

    public static void sendPlayFusionCraftingFinishedParticles(Level world, BlockPos pos, @NotNull ItemStack itemStack) {
        InkColor inkColor = ColorRegistry.ITEM_COLORS.getMapping(itemStack.getItem(), InkColors.LIGHT_GRAY);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)world), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new PlayFusionCraftingFinishedParticlePayload(pos, inkColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(PlayFusionCraftingFinishedParticlePayload payload, IPayloadContext context) {
        BlockPos pos = payload.pos;
        Vec3 sourcePos = new Vec3((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
        Vector3f color = payload.color.getColorVec();
        float velocityModifier = 0.25f;
        for (Vec3 velocity : VectorPattern.SIXTEEN.getVectors()) {
            context.player().level().addParticle((ParticleOptions)new DynamicParticleEffect(ColoredCraftingParticleEffect.of(payload.color.getColorInt()).getType(), 0.0f, color, 1.5f, 40, false, true), sourcePos.x, sourcePos.y, sourcePos.z, velocity.x * (double)velocityModifier, 0.0, velocity.z * (double)velocityModifier);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

