/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.blocks.pastel_network.Pastel;
import earth.terrarium.pastel.blocks.pastel_network.network.ClientPastelNetwork;
import earth.terrarium.pastel.blocks.pastel_network.network.ServerPastelNetwork;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public record PastelNetworkEdgeSyncPayload(UUID networkUUID, int color, Graph<BlockPos, DefaultEdge> graph) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, Graph<BlockPos, DefaultEdge>> GRAPH_PACKET_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Graph<BlockPos, DefaultEdge>>(){

        public void encode(RegistryFriendlyByteBuf buf, Graph<BlockPos, DefaultEdge> graph) {
            ArrayList vertices = new ArrayList(graph.vertexSet());
            buf.writeInt(vertices.size());
            for (BlockPos vertex : vertices) {
                buf.writeBlockPos(vertex);
            }
            Set edges = graph.edgeSet();
            buf.writeInt(edges.size());
            for (DefaultEdge edge : edges) {
                buf.writeInt(vertices.indexOf(graph.getEdgeSource((Object)edge)));
                buf.writeInt(vertices.indexOf(graph.getEdgeTarget((Object)edge)));
            }
        }

        public Graph<BlockPos, DefaultEdge> decode(RegistryFriendlyByteBuf buf) {
            SimpleGraph graph = new SimpleGraph(DefaultEdge.class);
            int vertexCount = buf.readInt();
            BlockPos[] vertices = new BlockPos[vertexCount];
            for (int i = 0; i < vertexCount; ++i) {
                BlockPos vertex;
                vertices[i] = vertex = buf.readBlockPos();
                graph.addVertex((Object)vertex);
            }
            int edgeCount = buf.readInt();
            for (int i = 0; i < edgeCount; ++i) {
                BlockPos source = vertices[buf.readInt()];
                BlockPos target = vertices[buf.readInt()];
                graph.addEdge((Object)source, (Object)target);
            }
            return graph;
        }
    };
    public static final CustomPacketPayload.Type<PastelNetworkEdgeSyncPayload> ID = PastelC2SPackets.makeId("pastel_network_edge_sync");
    public static final StreamCodec<RegistryFriendlyByteBuf, PastelNetworkEdgeSyncPayload> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, PastelNetworkEdgeSyncPayload::networkUUID, (StreamCodec)ByteBufCodecs.INT, PastelNetworkEdgeSyncPayload::color, GRAPH_PACKET_CODEC, PastelNetworkEdgeSyncPayload::graph, PastelNetworkEdgeSyncPayload::new);

    public static void send(ServerPastelNetwork network, BlockPos pos) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)network.getLevel()), (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)new PastelNetworkEdgeSyncPayload(network.getUUID(), network.getColor(), network.getGraph()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(PastelNetworkEdgeSyncPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Level level = context.player().level();
            Optional<? extends ClientPastelNetwork> network = Pastel.getClientInstance().getNetwork(payload.networkUUID);
            if (network.isPresent()) {
                network.get().setGraph(payload.graph);
            } else {
                ClientPastelNetwork newNetwork = Pastel.getClientInstance().createNetwork((ClientLevel)level, payload.networkUUID, payload.color);
                newNetwork.setGraph(payload.graph);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

