/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.networking.s2c_payloads;

import earth.terrarium.pastel.blocks.chests.BlackHoleChestBlockEntity;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.networking.PastelC2SPackets;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record BlackHoleChestStatusUpdatePayload(BlockPos pos, boolean isFull, boolean canStoreExperience, long storedExperience, long maxStoredExperience) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BlackHoleChestStatusUpdatePayload> ID = PastelC2SPackets.makeId("black_hole_chest_status_update");
    public static final StreamCodec<FriendlyByteBuf, BlackHoleChestStatusUpdatePayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BlackHoleChestStatusUpdatePayload::pos, (StreamCodec)ByteBufCodecs.BOOL, BlackHoleChestStatusUpdatePayload::isFull, (StreamCodec)ByteBufCodecs.BOOL, BlackHoleChestStatusUpdatePayload::canStoreExperience, (StreamCodec)ByteBufCodecs.VAR_LONG, BlackHoleChestStatusUpdatePayload::storedExperience, (StreamCodec)ByteBufCodecs.VAR_LONG, BlackHoleChestStatusUpdatePayload::maxStoredExperience, BlackHoleChestStatusUpdatePayload::new);

    public static void sendBlackHoleChestUpdate(BlackHoleChestBlockEntity chest) {
        ItemStack xpStack = chest.getItem(27);
        long storedXP = 0L;
        long maxStoredXP = 0L;
        Optional<ExperienceHandler> storage = chest.getExperienceStorage();
        if (storage.isPresent()) {
            storedXP = storage.get().getStoredAmount();
            maxStoredXP = storage.get().getCapacity();
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)chest.getLevel()), (ChunkPos)new ChunkPos(chest.getBlockPos()), (CustomPacketPayload)new BlackHoleChestStatusUpdatePayload(chest.getBlockPos(), chest.isFullServer(), chest.getExperienceStorage().isPresent(), storedXP, maxStoredXP), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void execute(BlackHoleChestStatusUpdatePayload payload, IPayloadContext context) {
        Level level = context.player().level();
        Optional entity = level.getBlockEntity(payload.pos, (BlockEntityType)PastelBlockEntities.BLACK_HOLE_CHEST.get());
        entity.ifPresent(chest -> {
            chest.setFull(payload.isFull);
            chest.setHasXPStorage(payload.canStoreExperience);
            chest.setXPData(payload.storedExperience, payload.maxStoredExperience);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

