/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeProvider;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.registries.PastelEntityTypeTags;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Projectile.class})
public abstract class ProjectileEntityMixin {
    @Shadow
    public abstract void shoot(double var1, double var3, double var5, float var7, float var8);

    @Inject(at={@At(value="HEAD")}, method={"onHitEntity"}, cancellable=true)
    protected void onProjectileHit(EntityHitResult entityHitResult, CallbackInfo ci) {
        Projectile thisEntity = (Projectile)this;
        if (!thisEntity.getType().is(PastelEntityTypeTags.UNDEFLECTABLE)) {
            Entity entity;
            Level world = thisEntity.level();
            if (!world.isClientSide && (entity = entityHitResult.getEntity()) instanceof LivingEntity) {
                float charges;
                LivingEntity livingEntity = (LivingEntity)entity;
                boolean protect = false;
                MobEffectInstance reboundInstance = livingEntity.getEffect(PastelMobEffects.PROJECTILE_REBOUND);
                if (reboundInstance != null && entity.level().getRandom().nextFloat() < 0.2f * (float)(reboundInstance.getAmplifier() + 1)) {
                    protect = true;
                } else if (PastelTrinketItem.hasEquipped(livingEntity, (Item)PastelItems.PUFF_CIRCLET.get()) && (charges = AzureDikeProvider.getAzureDikeCharges(livingEntity)) > 0.0f) {
                    AzureDikeProvider.absorbDamage(livingEntity, 4.0f);
                    protect = true;
                }
                if (protect) {
                    this.shoot(0.0, 0.0, 0.0, 0.0f, 0.0f);
                    PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)world, thisEntity.position(), ColoredCraftingParticleEffect.WHITE, 6, new Vec3(0.0, 0.0, 0.0), new Vec3(thisEntity.getX() - livingEntity.position().x, thisEntity.getY() - livingEntity.position().y, thisEntity.getZ() - livingEntity.position().z));
                    PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)world, thisEntity.position(), ColoredCraftingParticleEffect.BLUE, 6, new Vec3(0.0, 0.0, 0.0), new Vec3(thisEntity.getX() - livingEntity.position().x, thisEntity.getY() - livingEntity.position().y, thisEntity.getZ() - livingEntity.position().z));
                    world.playSound(null, thisEntity.blockPosition(), PastelSounds.PUFF_CIRCLET_PFFT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    livingEntity.hurtTime = Math.max(livingEntity.hurtTime, 1);
                    ci.cancel();
                }
            }
        }
    }
}

