/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import earth.terrarium.pastel.items.map.ArtisansAtlasState;
import earth.terrarium.pastel.networking.s2c_payloads.SyncArtisansAtlasPayload;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapItemSavedData.HoldingPlayer.class})
public class MapStatePlayerUpdateTrackerMixin {
    @Shadow
    @Final
    public Player player;

    @Inject(method={"nextUpdatePacket"}, at={@At(value="NEW", target="(Lnet/minecraft/world/level/saveddata/maps/MapId;BZLjava/util/Collection;Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData$MapPatch;)Lnet/minecraft/network/protocol/game/ClientboundMapItemDataPacket;")}, cancellable=true)
    private void getArtisansAtlasPacket(MapId mapId, CallbackInfoReturnable<Packet<?>> cir, @Local MapItemSavedData.MapPatch updateData, @Local Collection<MapDecoration> icons) {
        MapItemSavedData mapItemSavedData;
        Level world = this.player.level();
        if (world != null && (mapItemSavedData = world.getMapData(mapId)) instanceof ArtisansAtlasState) {
            ArtisansAtlasState state = (ArtisansAtlasState)mapItemSavedData;
            ClientboundMapItemDataPacket mapPacket = new ClientboundMapItemDataPacket(mapId, state.scale, state.locked, icons, updateData);
            SyncArtisansAtlasPayload payload = new SyncArtisansAtlasPayload(Optional.ofNullable(state.getTargetId()), mapPacket);
            ClientboundCustomPayloadPacket customPacket = new ClientboundCustomPayloadPacket((CustomPacketPayload)payload);
            cir.setReturnValue((Object)customPacket);
        }
    }
}

