/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.storage.FixedSingleInkStorage;
import earth.terrarium.pastel.api.entity.TouchingWaterAware;
import earth.terrarium.pastel.api.item.SlotReservingItem;
import earth.terrarium.pastel.attachments.data.EverpromiseRibbonData;
import earth.terrarium.pastel.attachments.data.MiscPlayerData;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeProvider;
import earth.terrarium.pastel.blocks.memory.MemoryItem;
import earth.terrarium.pastel.components.PairedFoodComponent;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.helpers.enchantments.InexorableHelper;
import earth.terrarium.pastel.injectors.MobEffectInstanceInjector;
import earth.terrarium.pastel.items.tools.ParryingSwordItem;
import earth.terrarium.pastel.items.trinkets.InkDrainTrinketItem;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.items.trinkets.RingOfAerialGraceItem;
import earth.terrarium.pastel.registries.PastelDamageTypeTags;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.status_effects.EffectProlongingStatusEffect;
import earth.terrarium.pastel.status_effects.SleepStatusEffect;
import java.util.Optional;
import java.util.Stack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    @Nullable
    protected Player lastHurtByPlayer;
    @Shadow
    protected ItemStack useItem;
    @Shadow
    public boolean dead;
    @Shadow
    protected Stack<DamageContainer> damageContainers;

    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    @Shadow
    public abstract ItemStack getMainHandItem();

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    @Shadow
    public abstract void readAdditionalSaveData(CompoundTag var1);

    @Shadow
    public abstract boolean hurt(DamageSource var1, float var2);

    @Shadow
    public abstract ItemStack getOffhandItem();

    @Shadow
    public abstract void remove(Entity.RemovalReason var1);

    @Shadow
    public abstract void travel(Vec3 var1);

    @Shadow
    public abstract double getAttributeValue(Holder<Attribute> var1);

    @Inject(method={"createLivingAttributes"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void addAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        ((AttributeSupplier.Builder)cir.getReturnValue()).add(PastelEntityAttributes.MENTAL_PRESENCE);
    }

    @ModifyArg(method={"dropExperience"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"), index=2)
    protected int applyExuberance(int originalXP) {
        return (int)((float)originalXP * this.getExuberanceMod(this.lastHurtByPlayer));
    }

    @Unique
    private float getExuberanceMod(Player attackingPlayer) {
        if (attackingPlayer != null) {
            int exuberanceLevel = Ench.getEquipmentLevel((HolderLookup.Provider)attackingPlayer.level().registryAccess(), PastelEnchantments.EXUBERANCE, (LivingEntity)attackingPlayer);
            return 1.0f + (float)exuberanceLevel * PastelCommon.CONFIG.ExuberanceBonusExperiencePercentPerLevel;
        }
        return 1.0f;
    }

    @WrapOperation(method={"travel"}, at={@At(value="INVOKE", target="Ljava/lang/Math;min(DD)D", ordinal=0)})
    private double noSlowFallingSlowdown(double gravity, double slowdown, Operation<Double> original) {
        if (InexorableHelper.isArmorActive((LivingEntity)this)) {
            return gravity;
        }
        return (Double)original.call(new Object[]{gravity, slowdown});
    }

    @Inject(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;shouldDiscardFriction()Z")})
    private void travel(CallbackInfo ci, @Local(ordinal=1) LocalFloatRef f) {
        Optional<ItemStack> optionalTrinket;
        LivingEntity entity = (LivingEntity)this;
        boolean override = false;
        float friction = -1.0f;
        if ((SlotReservingItem.isReservingSlot(this.getMainHandItem()) || SlotReservingItem.isReservingSlot(this.getOffhandItem())) && !entity.onGround()) {
            friction = 0.945f;
            override = true;
        }
        if (!entity.onGround() && (optionalTrinket = PastelTrinketItem.getFirstEquipped(entity, (Item)PastelItems.RING_OF_AERIAL_GRACE.get())).isPresent()) {
            FixedSingleInkStorage inkStorage = ((InkDrainTrinketItem)PastelItems.RING_OF_AERIAL_GRACE.get()).getEnergyStorage(optionalTrinket.get());
            long storedInk = inkStorage.getEnergy(inkStorage.getStoredColor());
            friction = (float)Math.max((double)friction, 0.91 + ((RingOfAerialGraceItem)PastelItems.RING_OF_AERIAL_GRACE.get()).getBonus(storedInk) / 150.0);
            override = true;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (override) {
                friction += MiscPlayerData.get(player).getFrictionModifiers();
            } else {
                f.set(Math.min(f.get() + MiscPlayerData.get(player).getFrictionModifiers(), 0.99f));
            }
        }
        if (friction >= 0.0f) {
            f.set(Math.min(friction, 0.99f));
        }
    }

    @ModifyExpressionValue(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFriction(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)F")})
    private float increaseSlipperiness(float original) {
        LivingEntity entity = (LivingEntity)this;
        RandomSource random = entity.getRandom();
        float potency = SleepStatusEffect.getSleepScaling(entity);
        if (potency != -1.0f) {
            potency *= 2.0f;
            if (entity instanceof Player && (double)random.nextFloat() < (double)potency * 0.05) {
                return 0.35f + random.nextFloat() * 0.45f;
            }
            original = (float)Math.min((double)original + 0.3 + (double)(potency / 25.0f), (double)0.9975f);
        }
        return original;
    }

    @ModifyReturnValue(method={"canStandOnFluid"}, at={@At(value="RETURN")})
    private boolean modifyFluidWalking(boolean original) {
        LivingEntity entity = (LivingEntity)this;
        if (PastelTrinketItem.hasEquipped(entity, (Item)PastelItems.RING_OF_AERIAL_GRACE.get())) {
            return !entity.isUnderWater();
        }
        return original;
    }

    @ModifyExpressionValue(method={"isBlocking"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;getUseDuration(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)I")})
    private int allowInstantBlockForParryingSwords(int original) {
        if (this.useItem.getItem() instanceof ParryingSwordItem) {
            return Integer.MAX_VALUE;
        }
        return original;
    }

    @WrapOperation(method={"handleEntityEvent"}, at={@At(value="INVOKE", target="net/minecraft/world/entity/LivingEntity.playSound (Lnet/minecraft/sounds/SoundEvent;FF)V", ordinal=1)})
    private void swapBlockSound(LivingEntity instance, SoundEvent soundEvent, float v, float p, Operation<Void> original) {
        Item item = instance.getUseItem().getItem();
        if (!(item instanceof ParryingSwordItem)) {
            original.call(new Object[]{instance, soundEvent, Float.valueOf(v), Float.valueOf(p)});
            return;
        }
        ParryingSwordItem parryingSword = (ParryingSwordItem)item;
        if (instance.getTicksUsingItem() <= parryingSword.getPerfectParryWindow(instance, instance.getUseItem())) {
            original.call(new Object[]{instance, PastelSounds.PERFECT_PARRY, Float.valueOf(1.75f), Float.valueOf(0.9f + instance.level().random.nextFloat() * 0.3f)});
            original.call(new Object[]{instance, PastelSounds.SWORD_BLOCK, Float.valueOf(0.667f), Float.valueOf(0.5f + instance.level().random.nextFloat() * 0.3f)});
        } else {
            original.call(new Object[]{instance, PastelSounds.SWORD_BLOCK, Float.valueOf(1.0f), Float.valueOf(0.8f + instance.level().random.nextFloat() * 0.4f)});
        }
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/food/FoodProperties;)V")})
    private void applyConcealedEffects(Level world, ItemStack stack, FoodProperties foodComponent, CallbackInfoReturnable<ItemStack> cir) {
        MobEffectInstance oilEffect = (MobEffectInstance)stack.get(PastelDataComponentTypes.CONCEALED_EFFECT);
        if (!world.isClientSide() && oilEffect != null) {
            ((LivingEntity)this).addEffect(oilEffect);
        }
    }

    @ModifyReturnValue(method={"isSleeping"}, at={@At(value="RETURN")})
    private boolean forceSleepingState(boolean original) {
        if (original) {
            return true;
        }
        if (this.hasEffect(PastelMobEffects.ETERNAL_SLUMBER) || this.hasEffect(PastelMobEffects.FATAL_SLUMBER)) {
            return !((LivingEntity)this instanceof Player);
        }
        return false;
    }

    @ModifyVariable(method={"setSprinting(Z)V"}, at=@At(value="HEAD"), argsOnly=true)
    private boolean setSprinting(boolean sprinting) {
        LivingEntity entity = (LivingEntity)this;
        if (sprinting && entity.hasEffect(PastelMobEffects.SCARRED)) {
            return false;
        }
        return sprinting;
    }

    @Inject(method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")})
    private void conditionalFood(Level world, ItemStack stack, FoodProperties foodProperties, CallbackInfoReturnable<ItemStack> cir) {
        PairedFoodComponent component = (PairedFoodComponent)stack.get(PastelDataComponentTypes.PAIRED_FOOD_COMPONENT);
        if (component != null) {
            component.tryEatFood(world, (LivingEntity)this, stack);
        }
    }

    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;")})
    private void addStatusEffect(MobEffectInstance effect, Entity source, CallbackInfoReturnable<Boolean> cir) {
        MobEffectInstance effectProlongingInstance;
        if (EffectProlongingStatusEffect.canBeExtended((Holder<MobEffect>)effect.getEffect()) && (effectProlongingInstance = this.getEffect(PastelMobEffects.EFFECT_PROLONGING)) != null) {
            ((MobEffectInstanceInjector)effect).setDuration(EffectProlongingStatusEffect.getExtendedDuration(effect.getDuration(), effectProlongingInstance.getAmplifier()));
        }
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="HEAD")}, cancellable=true)
    protected void drop(ServerLevel world, DamageSource damageSource, CallbackInfo ci) {
        LivingEntity thisEntity = (LivingEntity)this;
        if (EverpromiseRibbonData.hasRibbon(thisEntity)) {
            ItemStack memoryStack = MemoryItem.getMemoryForEntity(thisEntity);
            MemoryItem.setTicksToManifest(memoryStack, 20);
            MemoryItem.setSpawnAsAdult(memoryStack, true);
            MemoryItem.markAsBrokenPromise(memoryStack, true);
            Vec3 entityPos = thisEntity.position();
            ItemEntity itemEntity = new ItemEntity(thisEntity.level(), entityPos.x(), entityPos.y(), entityPos.z(), memoryStack);
            thisEntity.level().addFreshEntity((Entity)itemEntity);
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    protected void applyInexorableEffects(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.level() != null && entity.level().getGameTime() % 20L == 0L) {
            InexorableHelper.checkAndRemoveSlowdownModifiers(entity);
        }
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWaterRainOrBubble()Z"))
    private boolean isWet(LivingEntity livingEntity) {
        return livingEntity.isInWater() ? ((TouchingWaterAware)livingEntity).isActuallyTouchingWater() : livingEntity.isInWaterRainOrBubble();
    }

    @WrapOperation(at={@At(value="INVOKE", target="net/minecraft/world/entity/LivingEntity.actuallyHurt(Lnet/minecraft/world/damagesource/DamageSource;F)V")}, method={"hurt"})
    private void applyDike(LivingEntity instance, DamageSource source, float amount, Operation<Void> original) {
        if (source.is(PastelDamageTypeTags.BYPASSES_DIKE)) {
            original.call(new Object[]{instance, source, Float.valueOf(amount)});
            return;
        }
        DamageContainer container = this.damageContainers.peek();
        float passedDamage = AzureDikeProvider.absorbDamage(instance, container.getNewDamage());
        container.setNewDamage(passedDamage);
        instance.actuallyHurt(source, passedDamage);
    }
}

