/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import earth.terrarium.pastel.attachments.data.PrimordialFireData;
import earth.terrarium.pastel.helpers.enchantments.InexorableHelper;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @ModifyVariable(method={"makeStuckInBlock"}, at=@At(value="LOAD"), argsOnly=true)
    private Vec3 applyInexorableAntiBlockSlowdown(Vec3 multiplier) {
        LivingEntity livingEntity;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && InexorableHelper.isArmorActive(livingEntity = (LivingEntity)entity)) {
            return Vec3.ZERO;
        }
        return multiplier;
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="RETURN")}, cancellable=true)
    private void applyInexorableAntiSlowdown(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity;
        Entity entity = (Entity)this;
        if (((Float)cir.getReturnValue()).floatValue() < 1.0f && entity instanceof LivingEntity && InexorableHelper.isArmorActive(livingEntity = (LivingEntity)entity)) {
            cir.setReturnValue((Object)Float.valueOf(1.0f));
        }
    }

    @Inject(method={"spawnAtLocation(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="HEAD")}, cancellable=true)
    public void dropStack(ItemStack stack, CallbackInfoReturnable<ItemEntity> cir) {
        LivingEntity livingEntity;
        LivingEntity thisLivingEntity;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof LivingEntity && (thisLivingEntity = (LivingEntity)entityMixin).isDeadOrDying() && (livingEntity = thisLivingEntity.getLastHurtByMob()) instanceof Player) {
            Player killer = (Player)livingEntity;
            Boolean hasInventoryInsertion = thisLivingEntity.level().registryAccess().lookup(Registries.ENCHANTMENT).flatMap(impl -> impl.get(PastelEnchantments.INVENTORY_INSERTION)).map(e -> EnchantmentHelper.getEnchantmentLevel((Holder)e, (LivingEntity)killer) > 0).orElse(false);
            if (hasInventoryInsertion.booleanValue()) {
                Item item = stack.getItem();
                int count = stack.getCount();
                if (killer.getInventory().add(stack)) {
                    killer.level().playSound(null, killer.getX(), killer.getY(), killer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((killer.getRandom().nextFloat() - killer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    if (stack.isEmpty()) {
                        killer.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), count);
                        cir.cancel();
                    }
                    killer.awardStat(Stats.ITEM_PICKED_UP.get((Object)item), count - stack.getCount());
                }
            }
        }
    }

    @ModifyReturnValue(method={"getPose"}, at={@At(value="RETURN")})
    public Pose forceSleepPose(Pose original) {
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity)) {
            return original;
        }
        LivingEntity living = (LivingEntity)entity;
        if (!(entity instanceof Player) && (living.hasEffect(PastelMobEffects.ETERNAL_SLUMBER) || living.hasEffect(PastelMobEffects.FATAL_SLUMBER))) {
            return Pose.SLEEPING;
        }
        return original;
    }

    @ModifyReturnValue(method={"isOnFire"}, at={@At(value="RETURN")})
    public boolean considerPrimfireAsFire(boolean original) {
        LivingEntity living;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && PrimordialFireData.isOnPrimordialFire(living = (LivingEntity)entity)) {
            return true;
        }
        return original;
    }
}

