/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.status_effects.SleepStatusEffect;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Brain.class})
public abstract class BrainMixin<E extends LivingEntity> {
    @Shadow
    public abstract void setActiveActivityIfPossible(Activity var1);

    @Shadow
    public abstract <U> void eraseMemory(MemoryModuleType<U> var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void slowDownBrainTicks(ServerLevel world, E entity, CallbackInfo ci) {
        if (entity.hasEffect(PastelMobEffects.ETERNAL_SLUMBER) || entity.hasEffect(PastelMobEffects.FATAL_SLUMBER)) {
            ci.cancel();
            return;
        }
        MobEffectInstance effect = entity.getEffect(PastelMobEffects.SOMNOLENCE);
        if (effect == null) {
            return;
        }
        float scaling = SleepStatusEffect.getSleepScaling(entity);
        if (scaling <= 0.0f || (double)entity.getRandom().nextFloat() > Math.min((double)scaling * 0.05, 0.3)) {
            return;
        }
        if ((double)entity.getRandom().nextFloat() < (double)scaling * 0.5) {
            this.eraseMemory(MemoryModuleType.ANGRY_AT);
            this.setActiveActivityIfPossible(Activity.REST);
        }
        ci.cancel();
    }
}

