/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.mixin;

import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.item.GravitableItem;
import earth.terrarium.pastel.helpers.Support;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseEntityMixin {
    @Shadow
    protected SimpleContainer inventory;

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    public void tick(CallbackInfo callbackInfo) {
        Level level;
        AbstractChestedHorse thisEntity;
        AbstractHorse horse = (AbstractHorse)this;
        if (horse instanceof AbstractChestedHorse && !(thisEntity = (AbstractChestedHorse)horse).isNoGravity() && thisEntity.hasChest() && (level = thisEntity.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            double addedGravity = 0.0;
            for (ItemStack stack : this.inventory.getItems()) {
                Item item = stack.getItem();
                if (!(item instanceof GravitableItem)) continue;
                GravitableItem gravitableItem = (GravitableItem)item;
                addedGravity += gravitableItem.applyGravity(stack, (Level)serverWorld, (Entity)thisEntity);
            }
            if (addedGravity > 0.081 && serverWorld.getGameTime() % 20L == 0L) {
                Player owner = PlayerOwned.getPlayerEntityIfOnline(thisEntity.getOwnerUUID());
                if (owner != null) {
                    Support.grantAdvancementCriterion((ServerPlayer)owner, "lategame/put_too_many_low_gravity_blocks_into_animal", "gravity");
                }
                if (thisEntity.position().y > (double)(serverWorld.getHeight() + 1000)) {
                    thisEntity.hurt(thisEntity.damageSources().fellOutOfWorld(), 10.0f);
                }
            }
        }
    }
}

